# coding: utf-8

"""
    AutoTec Services API

    API for methods pertaining to all AutoTec services  # noqa: E501

    OpenAPI spec version: 1.0.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from autotec.api_client import ApiClient


class VehicleApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def calc_risk(self, request, **kwargs):  # noqa: E501
        """Calculates Risk of Loss for Requested Vehicles  # noqa: E501

        Method for calculating Loss Risk Prediction for a list of vehicles. The different types of Loss Risk Prediction varies in the algorithm multipliers and the history activity to utilize for each categorization of historical activity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.calc_risk(request, async=True)
        >>> result = thread.get()

        :param async bool
        :param RiskCalculationRequest request: The calculation request (required)
        :return: RiskCalculationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.calc_risk_with_http_info(request, **kwargs)  # noqa: E501
        else:
            (data) = self.calc_risk_with_http_info(request, **kwargs)  # noqa: E501
            return data

    def calc_risk_with_http_info(self, request, **kwargs):  # noqa: E501
        """Calculates Risk of Loss for Requested Vehicles  # noqa: E501

        Method for calculating Loss Risk Prediction for a list of vehicles. The different types of Loss Risk Prediction varies in the algorithm multipliers and the history activity to utilize for each categorization of historical activity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.calc_risk_with_http_info(request, async=True)
        >>> result = thread.get()

        :param async bool
        :param RiskCalculationRequest request: The calculation request (required)
        :return: RiskCalculationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method calc_risk" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `calc_risk`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/vehicle/risk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RiskCalculationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def history_full(self, request, **kwargs):  # noqa: E501
        """Retrieves Historical Activity for Requested Vehicles  # noqa: E501

        Method to retrieve vehicle history and ownership data (if authorized) for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_full(request, async=True)
        >>> result = thread.get()

        :param async bool
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.history_full_with_http_info(request, **kwargs)  # noqa: E501
        else:
            (data) = self.history_full_with_http_info(request, **kwargs)  # noqa: E501
            return data

    def history_full_with_http_info(self, request, **kwargs):  # noqa: E501
        """Retrieves Historical Activity for Requested Vehicles  # noqa: E501

        Method to retrieve vehicle history and ownership data (if authorized) for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_full_with_http_info(request, async=True)
        >>> result = thread.get()

        :param async bool
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method history_full" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `history_full`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/vehicle/history/full', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
