"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageManager = void 0;
const os = require("os");
const path = require("path");
/**
 * A node package manager
 */
class PackageManager {
    constructor(props) {
        this.lockFile = props.lockFile;
        this.installCommand = props.installCommand;
        this.runCommand = props.runCommand;
        this.argsSeparator = props.argsSeparator;
    }
    static fromLockFile(lockFilePath) {
        const lockFile = path.basename(lockFilePath);
        switch (lockFile) {
            case PackageManager.NPM.lockFile:
                return PackageManager.NPM;
            case PackageManager.YARN.lockFile:
                return PackageManager.YARN;
            case PackageManager.PNPM.lockFile:
                return PackageManager.PNPM;
            default:
                return PackageManager.NPM;
        }
    }
    runBinCommand(bin) {
        const [runCommand, ...runArgs] = this.runCommand;
        return [
            os.platform() === 'win32' ? `${runCommand}.cmd` : runCommand,
            ...runArgs,
            bin,
            ...(this.argsSeparator ? [this.argsSeparator] : []),
        ].join(' ');
    }
}
exports.PackageManager = PackageManager;
PackageManager.NPM = new PackageManager({
    lockFile: 'package-lock.json',
    installCommand: ['npm', 'install'],
    runCommand: ['npx', '--no-install'],
});
PackageManager.YARN = new PackageManager({
    lockFile: 'yarn.lock',
    installCommand: ['yarn', 'install'],
    runCommand: ['yarn', 'run'],
});
PackageManager.PNPM = new PackageManager({
    lockFile: 'pnpm-lock.yaml',
    installCommand: ['pnpm', 'install'],
    runCommand: ['pnpm', 'exec'],
    argsSeparator: '--',
});
//# sourceMappingURL=data:application/json;base64,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