import { AssetCode, Runtime } from '@aws-cdk/aws-lambda';
import * as cdk from '@aws-cdk/core';
import { BundlingOptions } from './types';
/**
 * Bundling properties
 */
export interface BundlingProps extends BundlingOptions {
    /**
     * Path to lock file
     */
    readonly depsLockFilePath: string;
    /**
     * Entry file
     */
    readonly entry: string;
    /**
     * The runtime of the lambda function
     */
    readonly runtime: Runtime;
    /**
     * Path to project root
     */
    readonly projectRoot: string;
}
/**
 * Bundling with esbuild
 */
export declare class Bundling implements cdk.BundlingOptions {
    private readonly props;
    /**
     * esbuild bundled Lambda asset code
     */
    static bundle(options: BundlingProps): AssetCode;
    static clearEsbuildInstallationCache(): void;
    private static esbuildInstallation?;
    readonly image: cdk.DockerImage;
    readonly command: string[];
    readonly environment?: {
        [key: string]: string;
    };
    readonly workingDirectory: string;
    readonly local?: cdk.ILocalBundling;
    private readonly projectRoot;
    private readonly relativeEntryPath;
    private readonly relativeTsconfigPath?;
    private readonly relativeDepsLockFilePath;
    private readonly externals;
    private readonly packageManager;
    constructor(props: BundlingProps);
    private createBundlingCommand;
    private getLocalBundlingProvider;
}
