"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageInstallation = void 0;
const child_process_1 = require("child_process");
const util_1 = require("./util");
/**
 * Package installation
 */
class PackageInstallation {
    static detect(module) {
        try {
            // Check local version first
            const version = util_1.tryGetModuleVersion(module);
            if (version) {
                return {
                    isLocal: true,
                    version,
                };
            }
            // Fallback to a global version
            const proc = child_process_1.spawnSync(module, ['--version']);
            if (proc.status === 0 && !proc.error) {
                return {
                    isLocal: false,
                    version: proc.stdout.toString().trim(),
                };
            }
            return undefined;
        }
        catch (err) {
            return undefined;
        }
    }
}
exports.PackageInstallation = PackageInstallation;
//# sourceMappingURL=data:application/json;base64,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