import * as lambda from '@aws-cdk/aws-lambda';
import { BundlingOptions } from './types';
import { Construct } from '@aws-cdk/core';
/**
 * Properties for a NodejsFunction.
 *
 * @stability stable
 */
export interface NodejsFunctionProps extends lambda.FunctionOptions {
    /**
     * Path to the entry file (JavaScript or TypeScript).
     *
     * @default - Derived from the name of the defining file and the construct's id.
     * If the `NodejsFunction` is defined in `stack.ts` with `my-handler` as id
     * (`new NodejsFunction(this, 'my-handler')`), the construct will look at `stack.my-handler.ts`
     * and `stack.my-handler.js`.
     * @stability stable
     */
    readonly entry?: string;
    /**
     * The name of the exported handler in the entry file.
     *
     * @default handler
     * @stability stable
     */
    readonly handler?: string;
    /**
     * The runtime environment.
     *
     * Only runtimes of the Node.js family are
     * supported.
     *
     * @default Runtime.NODEJS_14_X
     * @stability stable
     */
    readonly runtime?: lambda.Runtime;
    /**
     * Whether to automatically reuse TCP connections when working with the AWS SDK for JavaScript.
     *
     * This sets the `AWS_NODEJS_CONNECTION_REUSE_ENABLED` environment variable
     * to `1`.
     *
     * @default true
     * @see https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/node-reusing-connections.html
     * @stability stable
     */
    readonly awsSdkConnectionReuse?: boolean;
    /**
     * The path to the dependencies lock file (`yarn.lock` or `package-lock.json`).
     *
     * This will be used as the source for the volume mounted in the Docker
     * container.
     *
     * Modules specified in `nodeModules` will be installed using the right
     * installer (`npm` or `yarn`) along with this lock file.
     *
     * @default - the path is found by walking up parent directories searching for
     * a `yarn.lock` or `package-lock.json` file
     * @stability stable
     */
    readonly depsLockFilePath?: string;
    /**
     * Bundling options.
     *
     * @default - use default bundling options: no minify, no sourcemap, all
     * modules are bundled.
     * @stability stable
     */
    readonly bundling?: BundlingOptions;
    /**
     * The path to the directory containing project config files (`package.json` or `tsconfig.json`).
     *
     * @default - the directory containing the `depsLockFilePath`
     * @stability stable
     */
    readonly projectRoot?: string;
}
/**
 * A Node.js Lambda function bundled using esbuild.
 *
 * @stability stable
 */
export declare class NodejsFunction extends lambda.Function {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: NodejsFunctionProps);
}
