'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _posthtml = require('posthtml');

var _posthtml2 = _interopRequireDefault(_posthtml);

var _safe = require('./presets/safe');

var _safe2 = _interopRequireDefault(_safe);

var _ampSafe = require('./presets/ampSafe');

var _ampSafe2 = _interopRequireDefault(_ampSafe);

var _max = require('./presets/max');

var _max2 = _interopRequireDefault(_max);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function htmlnano() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var preset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _safe2.default;

    return function minifier(tree) {
        options = Object.assign({}, preset, options);
        var promise = Promise.resolve(tree);

        var _loop = function _loop(moduleName) {
            if (!options[moduleName]) {
                // The module is disabled
                return 'continue';
            }

            if (_safe2.default[moduleName] === undefined) {
                throw new Error('Module "' + moduleName + '" is not defined');
            }

            var module = require('./modules/' + moduleName);
            promise = promise.then(function (tree) {
                return module.default(tree, options, options[moduleName]);
            });
        };

        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
            for (var _iterator = Object.keys(options)[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                var moduleName = _step.value;

                var _ret = _loop(moduleName);

                if (_ret === 'continue') continue;
            }
        } catch (err) {
            _didIteratorError = true;
            _iteratorError = err;
        } finally {
            try {
                if (!_iteratorNormalCompletion && _iterator.return) {
                    _iterator.return();
                }
            } finally {
                if (_didIteratorError) {
                    throw _iteratorError;
                }
            }
        }

        return promise;
    };
}

htmlnano.process = function (html, options, preset) {
    return (0, _posthtml2.default)([htmlnano(options, preset)]).process(html);
};

htmlnano.presets = {
    safe: _safe2.default,
    ampSafe: _ampSafe2.default,
    max: _max2.default
};

exports.default = htmlnano;