'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = collapseAttributeWhitespace;
var attributesWithLists = exports.attributesWithLists = new Set(['class', 'rel', 'ping']);

/** Collapse whitespaces inside list-like attributes (e.g. class, rel) */
function collapseAttributeWhitespace(tree) {
    tree.walk(function (node) {
        if (!node.attrs) {
            return node;
        }

        Object.keys(node.attrs).forEach(function (attrName) {
            var attrNameLower = attrName.toLowerCase();
            if (!attributesWithLists.has(attrNameLower)) {
                return;
            }

            var attrValue = node.attrs[attrName].replace(/\s+/g, ' ').trim();
            node.attrs[attrName] = attrValue;
        });

        return node;
    });

    return tree;
}