'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = mergeStyles;

var _helpers = require('../helpers');

/* Merge multiple <style> into one */
function mergeStyles(tree) {
    var styleNodes = {};

    tree.match({ tag: 'style' }, function (node) {
        var nodeAttrs = node.attrs || {};
        // Skip <style scoped></style>
        // https://developer.mozilla.org/en/docs/Web/HTML/Element/style
        if (nodeAttrs.scoped !== undefined) {
            return node;
        }

        if ((0, _helpers.isAmpBoilerplate)(node)) {
            return node;
        }

        var styleType = nodeAttrs.type || 'text/css';
        var styleMedia = nodeAttrs.media || 'all';
        var styleKey = styleType + '_' + styleMedia;
        if (styleNodes[styleKey]) {
            var styleContent = (node.content || []).join(' ');
            styleNodes[styleKey].content.push(' ' + styleContent);
            return '';
        }

        node.content = node.content || [];
        styleNodes[styleKey] = node;
        return node;
    });

    return tree;
}