'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.default = removeUnusedCss;

var _helpers = require('../helpers');

var _uncss = require('uncss');

var _uncss2 = _interopRequireDefault(_uncss);

var _purgecss = require('purgecss');

var _purgecss2 = _interopRequireDefault(_purgecss);

var _posthtmlRender = require('posthtml-render');

var _posthtmlRender2 = _interopRequireDefault(_posthtmlRender);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

// These options must be set and shouldn't be overriden to ensure uncss doesn't look at linked stylesheets.
var uncssOptions = {
    ignoreSheets: [/\s*/],
    stylesheets: []
};

function processStyleNodeUnCSS(html, styleNode, uncssOptions) {
    var css = (0, _helpers.extractCssFromStyleNode)(styleNode);

    return runUncss(html, css, uncssOptions).then(function (css) {
        // uncss may have left some style tags empty
        if (css.trim().length === 0) {
            styleNode.tag = false;
            styleNode.content = [];
            return;
        }
        styleNode.content = [css];
    });
}

function runUncss(html, css, userOptions) {
    if ((typeof userOptions === 'undefined' ? 'undefined' : _typeof(userOptions)) !== 'object') {
        userOptions = {};
    }

    var options = Object.assign({}, userOptions, uncssOptions);
    return new Promise(function (resolve, reject) {
        options.raw = css;
        (0, _uncss2.default)(html, options, function (error, output) {
            if (error) {
                reject(error);
                return;
            }
            resolve(output);
        });
    });
}

var purgeFromHtml = function purgeFromHtml(tree) {
    // content is not used as we can directly used the parsed HTML,
    // making the process faster
    var selectors = [];

    tree.walk(function (node) {
        var classes = node.attrs && node.attrs.class && node.attrs.class.split(' ') || [];
        var ids = node.attrs && node.attrs.id && node.attrs.id.split(' ') || [];
        selectors.push.apply(selectors, _toConsumableArray(classes).concat(_toConsumableArray(ids)));
        node.tag && selectors.push(node.tag);
        return node;
    });

    return function () {
        return selectors;
    };
};

function processStyleNodePurgeCSS(tree, styleNode, purgecssOptions) {
    var css = (0, _helpers.extractCssFromStyleNode)(styleNode);
    return runPurgecss(tree, css, purgecssOptions).then(function (css) {
        if (css.trim().length === 0) {
            styleNode.tag = false;
            styleNode.content = [];
            return;
        }
        styleNode.content = [css];
    });
}

function runPurgecss(tree, css, userOptions) {
    if ((typeof userOptions === 'undefined' ? 'undefined' : _typeof(userOptions)) !== 'object') {
        userOptions = {};
    }

    var options = Object.assign({}, userOptions, {
        content: [{
            raw: tree,
            extension: 'html'
        }],
        css: [{
            raw: css,
            extension: 'css'
        }],
        extractors: [{
            extractor: purgeFromHtml(tree),
            extensions: ['html']
        }]
    });

    return new Promise(function (resolve, reject) {
        try {
            var purgeCss = new _purgecss2.default(options);
            var purgecssResult = purgeCss.purge()[0];
            resolve(purgecssResult.css);
        } catch (err) {
            reject(err);
        }
    });
}

/** Remove unused CSS */
function removeUnusedCss(tree, options, userOptions) {
    var promises = [];
    var html = userOptions.tool !== 'purgeCSS' && (0, _posthtmlRender2.default)(tree);

    tree.walk(function (node) {
        if ((0, _helpers.isStyleNode)(node)) {
            if (userOptions.tool === 'purgeCSS') {
                promises.push(processStyleNodePurgeCSS(tree, node, userOptions));
            } else {
                promises.push(processStyleNodeUnCSS(html, node, userOptions));
            }
        }
        return node;
    });

    return Promise.all(promises).then(function () {
        return tree;
    });
}