"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const child_process_1 = require("child_process");
const build_1 = require("../lib/build");
jest.mock('child_process', () => ({
    spawnSync: jest.fn((_cmd, args) => {
        if (args[1] === 'error') {
            return { error: 'parcel-error' };
        }
        if (args[1] === 'status') {
            return { status: 1, stdout: Buffer.from('status-error') };
        }
        return { error: null, status: 0 };
    })
}));
test('calls parcel with the correct args', () => {
    build_1.build({
        entry: 'entry',
        global: 'handler',
        outDir: 'out-dir',
        cacheDir: 'cache-dir',
    });
    expect(child_process_1.spawnSync).toHaveBeenCalledWith(expect.stringContaining('parcel-bundler'), expect.arrayContaining([
        'build', 'entry',
        '--out-dir', 'out-dir',
        '--out-file', 'index.js',
        '--global', 'handler',
        '--target', 'node',
        '--bundle-node-modules',
        '--log-level', '2',
        '--no-minify',
        '--no-source-maps',
        '--cache-dir', 'cache-dir'
    ]));
});
test('throws in case of error', () => {
    expect(() => build_1.build({
        entry: 'error',
        global: 'handler',
        outDir: 'out-dir'
    })).toThrow('parcel-error');
});
test('throws if status is not 0', () => {
    expect(() => build_1.build({
        entry: 'status',
        global: 'handler',
        outDir: 'out-dir'
    })).toThrow('status-error');
});
//# sourceMappingURL=data:application/json;base64,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