/// <reference types="node" />
/**
 * A parsed stack trace line
 */
export interface StackTrace {
    readonly file: string;
    readonly methodName?: string;
    readonly lineNumber: number;
    readonly column: number;
}
/**
 * Parses the stack trace of an error
 */
export declare function parseStackTrace(error?: Error): StackTrace[];
/**
 * Returns the major version of node installation
 */
export declare function nodeMajorVersion(): number;
/**
 * Finds closest package.json path
 */
export declare function findPkgPath(): string | undefined;
/**
 * Updates the package.json and returns the original
 */
export declare function updatePkg(pkgPath: string, data: any): Buffer;
