"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const child_process_1 = require("child_process");
const path = require("path");
const builder_1 = require("../lib/builder");
jest.mock('child_process', () => ({
    spawnSync: jest.fn((_cmd, args) => {
        if (args.includes('/project/folder/error')) {
            return { error: 'parcel-error' };
        }
        if (args.includes('/project/folder/status')) {
            return { status: 1, stdout: Buffer.from('status-error') };
        }
        if (args.includes('/project/folder/no-docker')) {
            return { error: 'Error: spawnSync docker ENOENT' };
        }
        return { error: null, status: 0 };
    }),
}));
test('calls docker with the correct args', () => {
    const builder = new builder_1.Builder({
        entry: '/project/folder/entry.ts',
        global: 'handler',
        outDir: '/out-dir',
        cacheDir: '/cache-dir',
        nodeDockerTag: 'lts-alpine',
        nodeVersion: '12',
        projectRoot: '/project',
    });
    builder.build();
    // docker build
    expect(child_process_1.spawnSync).toHaveBeenNthCalledWith(1, 'docker', [
        'build', '--build-arg', 'NODE_TAG=lts-alpine', '-t', 'parcel-bundler', path.join(__dirname, '../parcel-bundler'),
    ]);
    // docker run
    expect(child_process_1.spawnSync).toHaveBeenNthCalledWith(2, 'docker', [
        'run', '--rm',
        '-v', '/project:/project',
        '-v', '/out-dir:/out',
        '-v', '/cache-dir:/cache',
        '-w', '/project/folder',
        'parcel-bundler',
        'parcel', 'build', '/project/folder/entry.ts',
        '--out-dir', '/out',
        '--out-file', 'index.js',
        '--global', 'handler',
        '--target', 'node',
        '--bundle-node-modules',
        '--log-level', '2',
        '--no-minify',
        '--no-source-maps',
        '--cache-dir', '/cache',
    ]);
});
test('throws in case of error', () => {
    const builder = new builder_1.Builder({
        entry: '/project/folder/error',
        global: 'handler',
        outDir: 'out-dir',
        nodeDockerTag: 'lts-alpine',
        nodeVersion: '12',
        projectRoot: '/project',
    });
    expect(() => builder.build()).toThrow('parcel-error');
});
test('throws if status is not 0', () => {
    const builder = new builder_1.Builder({
        entry: '/project/folder/status',
        global: 'handler',
        outDir: 'out-dir',
        nodeDockerTag: 'lts-alpine',
        nodeVersion: '12',
        projectRoot: '/project',
    });
    expect(() => builder.build()).toThrow('status-error');
});
test('throws if docker is not installed', () => {
    const builder = new builder_1.Builder({
        entry: '/project/folder/no-docker',
        global: 'handler',
        outDir: 'out-dir',
        nodeDockerTag: 'lts-alpine',
        nodeVersion: '12',
        projectRoot: '/project',
    });
    expect(() => builder.build()).toThrow('Error: spawnSync docker ENOENT');
});
//# sourceMappingURL=data:application/json;base64,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