"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const path = require("path");
// From https://github.com/errwischt/stacktrace-parser/blob/master/src/stack-trace-parser.js
const STACK_RE = /^\s*at (?:((?:\[object object\])?[^\\/]+(?: \[as \S+\])?) )?\(?(.*?):(\d+)(?::(\d+))?\)?\s*$/i;
/**
 * Parses the stack trace of an error
 */
function parseStackTrace(error) {
    const err = error || new Error();
    if (!err.stack) {
        return [];
    }
    const lines = err.stack.split('\n');
    const stackTrace = [];
    for (const line of lines) {
        const results = STACK_RE.exec(line);
        if (results) {
            stackTrace.push({
                file: results[2],
                methodName: results[1],
                lineNumber: parseInt(results[3], 10),
                column: parseInt(results[4], 10),
            });
        }
    }
    return stackTrace;
}
exports.parseStackTrace = parseStackTrace;
/**
 * Returns the major version of node installation
 */
function nodeMajorVersion() {
    return parseInt(process.versions.node.split('.')[0], 10);
}
exports.nodeMajorVersion = nodeMajorVersion;
/**
 * Finds the closest path containg a path
 */
function findClosestPathContaining(p) {
    for (const nodeModulesPath of module.paths) {
        if (fs.existsSync(path.join(path.dirname(nodeModulesPath), p))) {
            return path.dirname(nodeModulesPath);
        }
    }
    return undefined;
}
/**
 * Finds closest package.json path
 */
function findPkgPath() {
    return findClosestPathContaining('package.json');
}
exports.findPkgPath = findPkgPath;
/**
 * Finds closest .git/
 */
function findGitPath() {
    return findClosestPathContaining(`.git${path.sep}`);
}
exports.findGitPath = findGitPath;
//# sourceMappingURL=data:application/json;base64,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