/**
 * A parsed stack trace line
 */
export interface StackTrace {
    readonly file: string;
    readonly methodName?: string;
    readonly lineNumber: number;
    readonly column: number;
}
/**
 * Parses the stack trace of an error
 */
export declare function parseStackTrace(error?: Error): StackTrace[];
/**
 * Returns the major version of node installation
 */
export declare function nodeMajorVersion(): number;
/**
 * Finds the closest path containg a path
 */
export declare function findClosestPathContaining(p: string): string | undefined;
