"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const child_process_1 = require("child_process");
const path = require("path");
beforeAll(() => {
    child_process_1.spawnSync('docker', ['build', '-t', 'parcel', path.join(__dirname, '../parcel')]);
});
test('parcel is available', async () => {
    const proc = child_process_1.spawnSync('docker', [
        'run', 'parcel',
        'sh', '-c',
        '$(node -p "require.resolve(\'parcel\')") --version',
    ]);
    expect(proc.status).toEqual(0);
});
test('can npm install with non root user', async () => {
    const proc = child_process_1.spawnSync('docker', [
        'run', '-u', '1000:1000',
        'parcel',
        'sh', '-c', [
            'mkdir /tmp/test',
            'cd /tmp/test',
            'npm i constructs',
        ].join(' && ')
    ]);
    expect(proc.status).toEqual(0);
});
test('can yarn install with non root user', async () => {
    const proc = child_process_1.spawnSync('docker', [
        'run', '-u', '500:500',
        'parcel',
        'sh', '-c', [
            'mkdir /tmp/test',
            'cd /tmp/test',
            'yarn add constructs',
        ].join(' && ')
    ]);
    expect(proc.status).toEqual(0);
});
//# sourceMappingURL=data:application/json;base64,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