import { Runtime } from '@aws-cdk/aws-lambda';
import * as cdk from '@aws-cdk/core';
interface BundlerProps {
    relativeEntryPath: string;
    cacheDir?: string;
    environment?: {
        [key: string]: string;
    };
    dependencies?: {
        [key: string]: string;
    };
    installer: Installer;
    lockFile?: LockFile;
}
interface LocalBundlerProps extends BundlerProps {
    projectRoot: string;
}
/**
 * Local Parcel bundler
 */
export declare class LocalBundler implements cdk.ILocalBundling {
    private readonly props;
    static get runsLocally(): boolean;
    static _runsLocally?: boolean;
    constructor(props: LocalBundlerProps);
    tryBundle(outputDir: string): boolean;
}
interface DockerBundlerProps extends BundlerProps {
    buildImage?: boolean;
    buildArgs?: {
        [key: string]: string;
    };
    runtime: Runtime;
    parcelVersion?: string;
}
/**
 * Docker bundler
 */
export declare class DockerBundler {
    readonly bundlingOptions: cdk.BundlingOptions;
    constructor(props: DockerBundlerProps);
}
export declare enum Installer {
    NPM = "npm",
    YARN = "yarn"
}
export declare enum LockFile {
    NPM = "package-lock.json",
    YARN = "yarn.lock"
}
export {};
