import * as lambda from '@aws-cdk/aws-lambda';
import * as cdk from '@aws-cdk/core';
import { ParcelBaseOptions } from './bundling';
/**
 * (experimental) Properties for a NodejsFunction.
 *
 * @experimental
 */
export interface NodejsFunctionProps extends lambda.FunctionOptions, ParcelBaseOptions {
    /**
     * (experimental) Path to the entry file (JavaScript or TypeScript).
     *
     * @default - Derived from the name of the defining file and the construct's id.
     * If the `NodejsFunction` is defined in `stack.ts` with `my-handler` as id
     * (`new NodejsFunction(this, 'my-handler')`), the construct will look at `stack.my-handler.ts`
     * and `stack.my-handler.js`.
     * @experimental
     */
    readonly entry?: string;
    /**
     * (experimental) The name of the exported handler in the entry file.
     *
     * @default handler
     * @experimental
     */
    readonly handler?: string;
    /**
     * (experimental) The runtime environment.
     *
     * Only runtimes of the Node.js family are
     * supported.
     *
     * @default - `NODEJS_12_X` if `process.versions.node` >= '12.0.0',
     * `NODEJS_10_X` otherwise.
     * @experimental
     */
    readonly runtime?: lambda.Runtime;
    /**
     * (experimental) Whether to automatically reuse TCP connections when working with the AWS SDK for JavaScript.
     *
     * This sets the `AWS_NODEJS_CONNECTION_REUSE_ENABLED` environment variable
     * to `1`.
     *
     * @default true
     * @see https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/node-reusing-connections.html
     * @experimental
     */
    readonly awsSdkConnectionReuse?: boolean;
}
/**
 * (experimental) A Node.js Lambda function bundled using Parcel.
 *
 * @experimental
 */
export declare class NodejsFunction extends lambda.Function {
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props?: NodejsFunctionProps);
}
