import * as lambda from '@aws-cdk/aws-lambda';
import { BundlingOptions } from './types';
import { Construct } from '@aws-cdk/core';
/**
 * (experimental) Properties for a NodejsFunction.
 *
 * @experimental
 */
export interface NodejsFunctionProps extends lambda.FunctionOptions {
    /**
     * (experimental) Path to the entry file (JavaScript or TypeScript).
     *
     * @default - Derived from the name of the defining file and the construct's id.
     * If the `NodejsFunction` is defined in `stack.ts` with `my-handler` as id
     * (`new NodejsFunction(this, 'my-handler')`), the construct will look at `stack.my-handler.ts`
     * and `stack.my-handler.js`.
     * @experimental
     */
    readonly entry?: string;
    /**
     * (experimental) The name of the exported handler in the entry file.
     *
     * @default handler
     * @experimental
     */
    readonly handler?: string;
    /**
     * (experimental) The runtime environment.
     *
     * Only runtimes of the Node.js family are
     * supported.
     *
     * @default - `NODEJS_14_X` if `process.versions.node` >= '14.0.0',
     * `NODEJS_12_X` otherwise.
     * @experimental
     */
    readonly runtime?: lambda.Runtime;
    /**
     * (experimental) Whether to automatically reuse TCP connections when working with the AWS SDK for JavaScript.
     *
     * This sets the `AWS_NODEJS_CONNECTION_REUSE_ENABLED` environment variable
     * to `1`.
     *
     * @default true
     * @see https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/node-reusing-connections.html
     * @experimental
     */
    readonly awsSdkConnectionReuse?: boolean;
    /**
     * (experimental) The path to the dependencies lock file (`yarn.lock` or `package-lock.json`).
     *
     * This will be used as the source for the volume mounted in the Docker
     * container.
     *
     * Modules specified in `nodeModules` will be installed using the right
     * installer (`npm` or `yarn`) along with this lock file.
     *
     * @default - the path is found by walking up parent directories searching for
     * a `yarn.lock` or `package-lock.json` file
     * @experimental
     */
    readonly depsLockFilePath?: string;
    /**
     * (experimental) Bundling options.
     *
     * @default - use default bundling options: no minify, no sourcemap, all
     * modules are bundled.
     * @experimental
     */
    readonly bundling?: BundlingOptions;
}
/**
 * (experimental) A Node.js Lambda function bundled using esbuild.
 *
 * @experimental
 */
export declare class NodejsFunction extends lambda.Function {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: NodejsFunctionProps);
}
