import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
/**
 * (experimental) Properties for PythonLayerVersion.
 *
 * @experimental
 */
export interface PythonLayerVersionProps extends lambda.LayerVersionOptions {
    /**
     * (experimental) The path to the root directory of the lambda layer.
     *
     * @experimental
     */
    readonly entry: string;
    /**
     * (experimental) The runtimes compatible with the python layer.
     *
     * @default - All runtimes are supported.
     * @experimental
     */
    readonly compatibleRuntimes?: lambda.Runtime[];
    /**
     * (experimental) The system architectures compatible with this layer.
     *
     * @default [Architecture.X86_64]
     * @experimental
     */
    readonly compatibleArchitectures?: lambda.Architecture[];
}
/**
 * (experimental) A lambda layer version.
 *
 * @experimental
 */
export declare class PythonLayerVersion extends lambda.LayerVersion {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: PythonLayerVersionProps);
}
