function _aws_cdk_aws_lambda_python_alpha_PythonFunctionProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.bundling))
            _aws_cdk_aws_lambda_python_alpha_BundlingOptions(p.bundling);
        if (p.events != null)
            for (const o of p.events)
                if (!visitedObjects.has(o))
                    require("aws-cdk-lib/.warnings.jsii.js").aws_cdk_lib_aws_lambda_IEventSource(o);
        if (p.initialPolicy != null)
            for (const o of p.initialPolicy)
                if (!visitedObjects.has(o))
                    require("aws-cdk-lib/.warnings.jsii.js").aws_cdk_lib_aws_iam_PolicyStatement(o);
        if (p.layers != null)
            for (const o of p.layers)
                if (!visitedObjects.has(o))
                    require("aws-cdk-lib/.warnings.jsii.js").aws_cdk_lib_aws_lambda_ILayerVersion(o);
        if ("logRetention" in p)
            print("aws-cdk-lib.aws_lambda.FunctionOptions#logRetention", "instead create a fully customizable log group with `logs.LogGroup` and use the `logGroup` property to instruct the Lambda function to send logs to it.\nMigrating from `logRetention` to `logGroup` will cause the name of the log group to change.\nUsers and code and referencing the name verbatim will have to adjust.\n\nIn AWS CDK code, you can access the log group name directly from the LogGroup construct:\n```ts\ndeclare const myLogGroup: logs.LogGroup;\nmyLogGroup.logGroupName;\n```");
        if ("logRetentionRetryOptions" in p)
            print("aws-cdk-lib.aws_lambda.FunctionOptions#logRetentionRetryOptions", "instead use `logGroup` to create a fully customizable log group and instruct the Lambda function to send logs to it.");
        if ("logRetentionRole" in p)
            print("aws-cdk-lib.aws_lambda.FunctionOptions#logRetentionRole", "instead use `logGroup` to create a fully customizable log group and instruct the Lambda function to send logs to it.");
        if (p.securityGroups != null)
            for (const o of p.securityGroups)
                if (!visitedObjects.has(o))
                    require("aws-cdk-lib/.warnings.jsii.js").aws_cdk_lib_aws_ec2_ISecurityGroup(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_lambda_python_alpha_PythonFunction(p) {
}
function _aws_cdk_aws_lambda_python_alpha_PythonLayerVersionProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.bundling))
            _aws_cdk_aws_lambda_python_alpha_BundlingOptions(p.bundling);
        if (p.compatibleArchitectures != null)
            for (const o of p.compatibleArchitectures)
                if (!visitedObjects.has(o))
                    require("aws-cdk-lib/.warnings.jsii.js").aws_cdk_lib_aws_lambda_Architecture(o);
        if (p.compatibleRuntimes != null)
            for (const o of p.compatibleRuntimes)
                if (!visitedObjects.has(o))
                    require("aws-cdk-lib/.warnings.jsii.js").aws_cdk_lib_aws_lambda_Runtime(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_lambda_python_alpha_PythonLayerVersion(p) {
}
function _aws_cdk_aws_lambda_python_alpha_BundlingOptions(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.commandHooks))
            _aws_cdk_aws_lambda_python_alpha_ICommandHooks(p.commandHooks);
        if (p.volumes != null)
            for (const o of p.volumes)
                if (!visitedObjects.has(o))
                    require("aws-cdk-lib/.warnings.jsii.js").aws_cdk_lib_DockerVolume(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_lambda_python_alpha_ICommandHooks(p) {
}
function print(name, deprecationMessage) {
    const deprecated = process.env.JSII_DEPRECATED;
    const deprecationMode = ["warn", "fail", "quiet"].includes(deprecated) ? deprecated : "warn";
    const message = `${name} is deprecated.\n  ${deprecationMessage.trim()}\n  This API will be removed in the next major release.`;
    switch (deprecationMode) {
        case "fail":
            throw new DeprecationError(message);
        case "warn":
            console.warn("[WARNING]", message);
            break;
    }
}
function getPropertyDescriptor(obj, prop) {
    const descriptor = Object.getOwnPropertyDescriptor(obj, prop);
    if (descriptor) {
        return descriptor;
    }
    const proto = Object.getPrototypeOf(obj);
    const prototypeDescriptor = proto && getPropertyDescriptor(proto, prop);
    if (prototypeDescriptor) {
        return prototypeDescriptor;
    }
    return {};
}
const visitedObjects = new Set();
class DeprecationError extends Error {
    constructor(...args) {
        super(...args);
        Object.defineProperty(this, "name", {
            configurable: false,
            enumerable: true,
            value: "DeprecationError",
            writable: false,
        });
    }
}
module.exports = { print, getPropertyDescriptor, DeprecationError, _aws_cdk_aws_lambda_python_alpha_PythonFunctionProps, _aws_cdk_aws_lambda_python_alpha_PythonFunction, _aws_cdk_aws_lambda_python_alpha_PythonLayerVersionProps, _aws_cdk_aws_lambda_python_alpha_PythonLayerVersion, _aws_cdk_aws_lambda_python_alpha_BundlingOptions, _aws_cdk_aws_lambda_python_alpha_ICommandHooks };
