"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonFunction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const core_1 = require("aws-cdk-lib/core");
const bundling_1 = require("./bundling");
/**
 * A Python Lambda function
 */
class PythonFunction extends aws_lambda_1.Function {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_python_alpha_PythonFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PythonFunction);
            }
            throw error;
        }
        const { index = 'index.py', handler = 'handler', runtime } = props;
        if (props.index && !/\.py$/.test(props.index)) {
            throw new Error('Only Python (.py) index files are supported.');
        }
        // Entry
        const entry = path.resolve(props.entry);
        const resolvedIndex = path.resolve(entry, index);
        if (!fs.existsSync(resolvedIndex)) {
            throw new Error(`Cannot find index file at ${resolvedIndex}`);
        }
        const resolvedHandler = `${index.slice(0, -3)}.${handler}`.replace(/\//g, '.');
        if (props.runtime && props.runtime.family !== aws_lambda_1.RuntimeFamily.PYTHON) {
            throw new Error('Only `PYTHON` runtimes are supported.');
        }
        super(scope, id, {
            ...props,
            runtime,
            code: bundling_1.Bundling.bundle({
                entry,
                runtime,
                skip: !core_1.Stack.of(scope).bundlingRequired,
                // define architecture based on the target architecture of the function, possibly overriden in bundling options
                architecture: props.architecture,
                ...props.bundling,
            }),
            handler: resolvedHandler,
        });
    }
}
exports.PythonFunction = PythonFunction;
_a = JSII_RTTI_SYMBOL_1;
PythonFunction[_a] = { fqn: "@aws-cdk/aws-lambda-python-alpha.PythonFunction", version: "2.132.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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