"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonLayerVersion = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("aws-cdk-lib/aws-lambda");
const core_1 = require("aws-cdk-lib/core");
const bundling_1 = require("./bundling");
/**
 * A lambda layer version.
 *
 */
class PythonLayerVersion extends lambda.LayerVersion {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_python_alpha_PythonLayerVersionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PythonLayerVersion);
            }
            throw error;
        }
        const compatibleRuntimes = props.compatibleRuntimes ?? [lambda.Runtime.PYTHON_3_7];
        const compatibleArchitectures = props.compatibleArchitectures ?? [lambda.Architecture.X86_64];
        // Ensure that all compatible runtimes are python
        for (const runtime of compatibleRuntimes) {
            if (runtime && runtime.family !== lambda.RuntimeFamily.PYTHON) {
                throw new Error('Only `PYTHON` runtimes are supported.');
            }
        }
        // Entry and defaults
        const entry = path.resolve(props.entry);
        // Pick the first compatibleRuntime and compatibleArchitectures to use for bundling
        const runtime = compatibleRuntimes[0];
        const architecture = compatibleArchitectures[0];
        super(scope, id, {
            ...props,
            compatibleRuntimes,
            code: bundling_1.Bundling.bundle({
                entry,
                runtime,
                architecture,
                outputPathSuffix: 'python',
                skip: !core_1.Stack.of(scope).bundlingRequired,
                ...props.bundling,
            }),
        });
    }
}
exports.PythonLayerVersion = PythonLayerVersion;
_a = JSII_RTTI_SYMBOL_1;
PythonLayerVersion[_a] = { fqn: "@aws-cdk/aws-lambda-python-alpha.PythonLayerVersion", version: "2.173.3-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGF5ZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsYXllci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSw2QkFBNkI7QUFDN0IsaURBQWlEO0FBQ2pELDJDQUF5QztBQUV6Qyx5Q0FBc0M7QUFpQ3RDOzs7R0FHRztBQUNILE1BQWEsa0JBQW1CLFNBQVEsTUFBTSxDQUFDLFlBQVk7SUFDekQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE4Qjs7Ozs7OytDQUQ3RCxrQkFBa0I7Ozs7UUFFM0IsTUFBTSxrQkFBa0IsR0FBRyxLQUFLLENBQUMsa0JBQWtCLElBQUksQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ25GLE1BQU0sdUJBQXVCLEdBQUcsS0FBSyxDQUFDLHVCQUF1QixJQUFJLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUU5RixpREFBaUQ7UUFDakQsS0FBSyxNQUFNLE9BQU8sSUFBSSxrQkFBa0IsRUFBRSxDQUFDO1lBQ3pDLElBQUksT0FBTyxJQUFJLE9BQU8sQ0FBQyxNQUFNLEtBQUssTUFBTSxDQUFDLGFBQWEsQ0FBQyxNQUFNLEVBQUUsQ0FBQztnQkFDOUQsTUFBTSxJQUFJLEtBQUssQ0FBQyx1Q0FBdUMsQ0FBQyxDQUFDO1lBQzNELENBQUM7UUFDSCxDQUFDO1FBRUQscUJBQXFCO1FBQ3JCLE1BQU0sS0FBSyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ3hDLG1GQUFtRjtRQUNuRixNQUFNLE9BQU8sR0FBRyxrQkFBa0IsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUN0QyxNQUFNLFlBQVksR0FBRyx1QkFBdUIsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUVoRCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLEdBQUcsS0FBSztZQUNSLGtCQUFrQjtZQUNsQixJQUFJLEVBQUUsbUJBQVEsQ0FBQyxNQUFNLENBQUM7Z0JBQ3BCLEtBQUs7Z0JBQ0wsT0FBTztnQkFDUCxZQUFZO2dCQUNaLGdCQUFnQixFQUFFLFFBQVE7Z0JBQzFCLElBQUksRUFBRSxDQUFDLFlBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUMsZ0JBQWdCO2dCQUN2QyxHQUFHLEtBQUssQ0FBQyxRQUFRO2FBQ2xCLENBQUM7U0FDSCxDQUFDLENBQUM7S0FDSjs7QUE5QkgsZ0RBK0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbGFtYmRhJztcbmltcG9ydCB7IFN0YWNrIH0gZnJvbSAnYXdzLWNkay1saWIvY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IEJ1bmRsaW5nIH0gZnJvbSAnLi9idW5kbGluZyc7XG5pbXBvcnQgeyBCdW5kbGluZ09wdGlvbnMgfSBmcm9tICcuL3R5cGVzJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBQeXRob25MYXllclZlcnNpb25cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBQeXRob25MYXllclZlcnNpb25Qcm9wcyBleHRlbmRzIGxhbWJkYS5MYXllclZlcnNpb25PcHRpb25zIHtcbiAgLyoqXG4gICAqIFRoZSBwYXRoIHRvIHRoZSByb290IGRpcmVjdG9yeSBvZiB0aGUgbGFtYmRhIGxheWVyLlxuICAgKi9cbiAgcmVhZG9ubHkgZW50cnk6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHJ1bnRpbWVzIGNvbXBhdGlibGUgd2l0aCB0aGUgcHl0aG9uIGxheWVyLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE9ubHkgUHl0aG9uIDMuNyBpcyBzdXBwb3J0ZWQuXG4gICAqL1xuICByZWFkb25seSBjb21wYXRpYmxlUnVudGltZXM/OiBsYW1iZGEuUnVudGltZVtdO1xuXG4gIC8qKlxuICAgKiBUaGUgc3lzdGVtIGFyY2hpdGVjdHVyZXMgY29tcGF0aWJsZSB3aXRoIHRoaXMgbGF5ZXIuXG4gICAqIEBkZWZhdWx0IFtBcmNoaXRlY3R1cmUuWDg2XzY0XVxuICAgKi9cbiAgcmVhZG9ubHkgY29tcGF0aWJsZUFyY2hpdGVjdHVyZXM/OiBsYW1iZGEuQXJjaGl0ZWN0dXJlW107XG4gIC8qKlxuICAgKiBCdW5kbGluZyBvcHRpb25zIHRvIHVzZSBmb3IgdGhpcyBmdW5jdGlvbi4gVXNlIHRoaXMgdG8gc3BlY2lmeSBjdXN0b20gYnVuZGxpbmcgb3B0aW9ucyBsaWtlXG4gICAqIHRoZSBidW5kbGluZyBEb2NrZXIgaW1hZ2UsIGFzc2V0IGhhc2ggdHlwZSwgY3VzdG9tIGhhc2gsIGFyY2hpdGVjdHVyZSwgZXRjLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIFVzZSB0aGUgZGVmYXVsdCBidW5kbGluZyBEb2NrZXIgaW1hZ2UsIHdpdGggeDg2XzY0IGFyY2hpdGVjdHVyZS5cbiAgICovXG4gIHJlYWRvbmx5IGJ1bmRsaW5nPzogQnVuZGxpbmdPcHRpb25zO1xufVxuXG4vKipcbiAqIEEgbGFtYmRhIGxheWVyIHZlcnNpb24uXG4gKlxuICovXG5leHBvcnQgY2xhc3MgUHl0aG9uTGF5ZXJWZXJzaW9uIGV4dGVuZHMgbGFtYmRhLkxheWVyVmVyc2lvbiB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBQeXRob25MYXllclZlcnNpb25Qcm9wcykge1xuICAgIGNvbnN0IGNvbXBhdGlibGVSdW50aW1lcyA9IHByb3BzLmNvbXBhdGlibGVSdW50aW1lcyA/PyBbbGFtYmRhLlJ1bnRpbWUuUFlUSE9OXzNfN107XG4gICAgY29uc3QgY29tcGF0aWJsZUFyY2hpdGVjdHVyZXMgPSBwcm9wcy5jb21wYXRpYmxlQXJjaGl0ZWN0dXJlcyA/PyBbbGFtYmRhLkFyY2hpdGVjdHVyZS5YODZfNjRdO1xuXG4gICAgLy8gRW5zdXJlIHRoYXQgYWxsIGNvbXBhdGlibGUgcnVudGltZXMgYXJlIHB5dGhvblxuICAgIGZvciAoY29uc3QgcnVudGltZSBvZiBjb21wYXRpYmxlUnVudGltZXMpIHtcbiAgICAgIGlmIChydW50aW1lICYmIHJ1bnRpbWUuZmFtaWx5ICE9PSBsYW1iZGEuUnVudGltZUZhbWlseS5QWVRIT04pIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdPbmx5IGBQWVRIT05gIHJ1bnRpbWVzIGFyZSBzdXBwb3J0ZWQuJyk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgLy8gRW50cnkgYW5kIGRlZmF1bHRzXG4gICAgY29uc3QgZW50cnkgPSBwYXRoLnJlc29sdmUocHJvcHMuZW50cnkpO1xuICAgIC8vIFBpY2sgdGhlIGZpcnN0IGNvbXBhdGlibGVSdW50aW1lIGFuZCBjb21wYXRpYmxlQXJjaGl0ZWN0dXJlcyB0byB1c2UgZm9yIGJ1bmRsaW5nXG4gICAgY29uc3QgcnVudGltZSA9IGNvbXBhdGlibGVSdW50aW1lc1swXTtcbiAgICBjb25zdCBhcmNoaXRlY3R1cmUgPSBjb21wYXRpYmxlQXJjaGl0ZWN0dXJlc1swXTtcblxuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgLi4ucHJvcHMsXG4gICAgICBjb21wYXRpYmxlUnVudGltZXMsXG4gICAgICBjb2RlOiBCdW5kbGluZy5idW5kbGUoe1xuICAgICAgICBlbnRyeSxcbiAgICAgICAgcnVudGltZSxcbiAgICAgICAgYXJjaGl0ZWN0dXJlLFxuICAgICAgICBvdXRwdXRQYXRoU3VmZml4OiAncHl0aG9uJyxcbiAgICAgICAgc2tpcDogIVN0YWNrLm9mKHNjb3BlKS5idW5kbGluZ1JlcXVpcmVkLFxuICAgICAgICAuLi5wcm9wcy5idW5kbGluZyxcbiAgICAgIH0pLFxuICAgIH0pO1xuICB9XG59XG4iXX0=