"use strict";
var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonFunction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const core_1 = require("aws-cdk-lib/core");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
const bundling_1 = require("./bundling");
/**
 * A Python Lambda function
 */
let PythonFunction = (() => {
    let _classDecorators = [prop_injectable_1.propertyInjectable];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = aws_lambda_1.Function;
    var PythonFunction = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            PythonFunction = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
        }
        static [JSII_RTTI_SYMBOL_1] = { fqn: "@aws-cdk/aws-lambda-python-alpha.PythonFunction", version: "2.234.0-alpha.0" };
        /** Uniquely identifies this class. */
        static PROPERTY_INJECTION_ID = '@aws-cdk.aws-lambda-python-alpha.PythonFunction';
        constructor(scope, id, props) {
            try {
                jsiiDeprecationWarnings._aws_cdk_aws_lambda_python_alpha_PythonFunctionProps(props);
            }
            catch (error) {
                if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                    Error.captureStackTrace(error, PythonFunction);
                }
                throw error;
            }
            const { index = 'index.py', handler = 'handler', runtime } = props;
            if (props.index && !/\.py$/.test(props.index)) {
                throw new Error('Only Python (.py) index files are supported.');
            }
            // Entry
            const entry = path.resolve(props.entry);
            const resolvedIndex = path.resolve(entry, index);
            if (!fs.existsSync(resolvedIndex)) {
                throw new Error(`Cannot find index file at ${resolvedIndex}`);
            }
            const resolvedHandler = `${index.slice(0, -3)}.${handler}`.replace(/\//g, '.');
            if (props.runtime && props.runtime.family !== aws_lambda_1.RuntimeFamily.PYTHON) {
                throw new Error('Only `PYTHON` runtimes are supported.');
            }
            super(scope, id, {
                ...props,
                runtime,
                code: bundling_1.Bundling.bundle({
                    entry,
                    runtime,
                    skip: !core_1.Stack.of(scope).bundlingRequired,
                    // define architecture based on the target architecture of the function, possibly overridden in bundling options
                    architecture: props.architecture,
                    ...props.bundling,
                }),
                handler: resolvedHandler,
            });
            // Enhanced CDK Analytics Telemetry
            (0, metadata_resource_1.addConstructMetadata)(this, props);
        }
        static {
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return PythonFunction = _classThis;
})();
exports.PythonFunction = PythonFunction;
//# sourceMappingURL=data:application/json;base64,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