"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonLayerVersion = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const bundling_1 = require("./bundling");
/**
 * A lambda layer version.
 *
 */
class PythonLayerVersion extends lambda.LayerVersion {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_python_alpha_PythonLayerVersionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PythonLayerVersion);
            }
            throw error;
        }
        const compatibleRuntimes = props.compatibleRuntimes ?? [lambda.Runtime.PYTHON_3_7];
        const compatibleArchitectures = props.compatibleArchitectures ?? [lambda.Architecture.X86_64];
        // Ensure that all compatible runtimes are python
        for (const runtime of compatibleRuntimes) {
            if (runtime && runtime.family !== lambda.RuntimeFamily.PYTHON) {
                throw new Error('Only `PYTHON` runtimes are supported.');
            }
        }
        // Entry and defaults
        const entry = path.resolve(props.entry);
        // Pick the first compatibleRuntime and compatibleArchitectures to use for bundling
        const runtime = compatibleRuntimes[0];
        const architecture = compatibleArchitectures[0];
        super(scope, id, {
            ...props,
            compatibleRuntimes,
            code: bundling_1.Bundling.bundle({
                entry,
                runtime,
                architecture,
                outputPathSuffix: 'python',
                skip: !aws_cdk_lib_1.Stack.of(scope).bundlingRequired,
                ...props.bundling,
            }),
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
PythonLayerVersion[_a] = { fqn: "@aws-cdk/aws-lambda-python-alpha.PythonLayerVersion", version: "2.75.1-alpha.0" };
exports.PythonLayerVersion = PythonLayerVersion;
//# sourceMappingURL=data:application/json;base64,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