"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonLayerVersion = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const bundling_1 = require("./bundling");
/**
 * (experimental) A lambda layer version.
 *
 * @experimental
 */
class PythonLayerVersion extends lambda.LayerVersion {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_python_PythonLayerVersionProps(props);
        const compatibleRuntimes = (_b = props.compatibleRuntimes) !== null && _b !== void 0 ? _b : [lambda.Runtime.PYTHON_3_7];
        const compatibleArchitectures = (_c = props.compatibleArchitectures) !== null && _c !== void 0 ? _c : [lambda.Architecture.X86_64];
        // Ensure that all compatible runtimes are python
        for (const runtime of compatibleRuntimes) {
            if (runtime && runtime.family !== lambda.RuntimeFamily.PYTHON) {
                throw new Error('Only `PYTHON` runtimes are supported.');
            }
        }
        // Entry and defaults
        const entry = path.resolve(props.entry);
        // Pick the first compatibleRuntime and compatibleArchitectures to use for bundling
        const runtime = compatibleRuntimes[0];
        const architecture = compatibleArchitectures[0];
        super(scope, id, {
            ...props,
            compatibleRuntimes,
            code: bundling_1.Bundling.bundle({
                entry,
                runtime,
                architecture,
                outputPathSuffix: 'python',
                ...props.bundling,
            }),
        });
    }
}
exports.PythonLayerVersion = PythonLayerVersion;
_a = JSII_RTTI_SYMBOL_1;
PythonLayerVersion[_a] = { fqn: "@aws-cdk/aws-lambda-python.PythonLayerVersion", version: "1.140.0" };
//# sourceMappingURL=data:application/json;base64,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