"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonLayerVersion = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const bundling_1 = require("./bundling");
/**
 * A lambda layer version.
 *
 */
class PythonLayerVersion extends lambda.LayerVersion {
    constructor(scope, id, props) {
        var _b, _c;
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_python_PythonLayerVersionProps(props);
        const compatibleRuntimes = (_b = props.compatibleRuntimes) !== null && _b !== void 0 ? _b : [lambda.Runtime.PYTHON_3_7];
        const compatibleArchitectures = (_c = props.compatibleArchitectures) !== null && _c !== void 0 ? _c : [lambda.Architecture.X86_64];
        // Ensure that all compatible runtimes are python
        for (const runtime of compatibleRuntimes) {
            if (runtime && runtime.family !== lambda.RuntimeFamily.PYTHON) {
                throw new Error('Only `PYTHON` runtimes are supported.');
            }
        }
        // Entry and defaults
        const entry = path.resolve(props.entry);
        // Pick the first compatibleRuntime and compatibleArchitectures to use for bundling
        const runtime = compatibleRuntimes[0];
        const architecture = compatibleArchitectures[0];
        super(scope, id, {
            ...props,
            compatibleRuntimes,
            code: bundling_1.Bundling.bundle({
                entry,
                runtime,
                architecture,
                outputPathSuffix: 'python',
                ...props.bundling,
            }),
        });
    }
}
exports.PythonLayerVersion = PythonLayerVersion;
_a = JSII_RTTI_SYMBOL_1;
PythonLayerVersion[_a] = { fqn: "@aws-cdk/aws-lambda-python.PythonLayerVersion", version: "1.146.0" };
//# sourceMappingURL=data:application/json;base64,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