"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonFunction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const bundling_1 = require("./bundling");
/**
 * A Python Lambda function
 */
class PythonFunction extends aws_lambda_1.Function {
    constructor(scope, id, props) {
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_python_PythonFunctionProps(props);
        const { index = 'index.py', handler = 'handler', runtime } = props;
        if (props.index && !/\.py$/.test(props.index)) {
            throw new Error('Only Python (.py) index files are supported.');
        }
        // Entry
        const entry = path.resolve(props.entry);
        const resolvedIndex = path.resolve(entry, index);
        if (!fs.existsSync(resolvedIndex)) {
            throw new Error(`Cannot find index file at ${resolvedIndex}`);
        }
        const resolvedHandler = `${index.slice(0, -3)}.${handler}`.replace('/', '.');
        if (props.runtime && props.runtime.family !== aws_lambda_1.RuntimeFamily.PYTHON) {
            throw new Error('Only `PYTHON` runtimes are supported.');
        }
        super(scope, id, {
            ...props,
            runtime,
            code: bundling_1.Bundling.bundle({
                entry,
                runtime,
                skip: !core_1.Stack.of(scope).bundlingRequired,
                ...props.bundling,
            }),
            handler: resolvedHandler,
        });
    }
}
exports.PythonFunction = PythonFunction;
_a = JSII_RTTI_SYMBOL_1;
PythonFunction[_a] = { fqn: "@aws-cdk/aws-lambda-python.PythonFunction", version: "1.152.0" };
//# sourceMappingURL=data:application/json;base64,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