import { Function, FunctionOptions, Runtime } from '@aws-cdk/aws-lambda';
import { BundlingOptions } from './types';
import { Construct } from '@aws-cdk/core';
/**
 * Properties for a PythonFunction
 */
export interface PythonFunctionProps extends FunctionOptions {
    /**
     * Path to the source of the function or the location for dependencies.
     */
    readonly entry: string;
    /**
     * The runtime environment. Only runtimes of the Python family are
     * supported.
     *
     * @default Runtime.PYTHON_3_7
     */
    readonly runtime: Runtime;
    /**
     * The path (relative to entry) to the index file containing the exported handler.
     *
     * @default index.py
     */
    readonly index?: string;
    /**
     * The name of the exported handler in the index file.
     *
     * @default handler
     */
    readonly handler?: string;
    /**
     * Bundling options to use for this function. Use this to specify custom bundling options like
     * the bundling Docker image, asset hash type, custom hash, architecture, etc.
     *
     * @default - Use the default bundling Docker image, with x86_64 architecture.
     */
    readonly bundling?: BundlingOptions;
}
/**
 * A Python Lambda function
 */
export declare class PythonFunction extends Function {
    constructor(scope: Construct, id: string, props: PythonFunctionProps);
}
