import * as lambda from '@aws-cdk/aws-lambda';
import * as cdk from '@aws-cdk/core';
/**
 * Properties for a PythonFunction
 */
export interface PythonFunctionProps extends lambda.FunctionOptions {
    /**
     * The path to the root directory of the function.
     */
    readonly entry: string;
    /**
     * The path (relative to entry) to the index file containing the exported handler.
     *
     * @default index.py
     */
    readonly index?: string;
    /**
     * The name of the exported handler in the index file.
     *
     * @default handler
     */
    readonly handler?: string;
    /**
     * The runtime environment. Only runtimes of the Python family are
     * supported.
     *
     * @default lambda.Runtime.PYTHON_3_7
     */
    readonly runtime?: lambda.Runtime;
}
/**
 * A Python Lambda function
 */
export declare class PythonFunction extends lambda.Function {
    constructor(scope: cdk.Construct, id: string, props: PythonFunctionProps);
}
