"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assetHash = exports.ASSET_FILE = void 0;
const crypto = require("crypto");
const fs = require("fs");
const path = require("path");
exports.ASSET_FILE = path.join(__dirname, 'layer.zip');
// we hash the Dockerfile (it contains the tools versions) because hashing the zip is non-deterministic
function assetHash() {
    // This could be calculated at build time
    return hashFile(path.join(__dirname, '..', 'layer', 'Dockerfile'));
}
exports.assetHash = assetHash;
function hashFile(fileName) {
    return crypto
        .createHash('sha256')
        .update(fs.readFileSync(fileName))
        .digest('hex');
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiX2Fzc2V0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL19hc3NldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxpQ0FBaUM7QUFDakMseUJBQXlCO0FBQ3pCLDZCQUE2QjtBQUVoQixRQUFBLFVBQVUsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxXQUFXLENBQUMsQ0FBQztBQUU1RCx1R0FBdUc7QUFDdkcsU0FBZ0IsU0FBUztJQUN2Qix5Q0FBeUM7SUFDekMsT0FBTyxRQUFRLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxZQUFZLENBQUMsQ0FBQyxDQUFDO0FBQ3JFLENBQUM7QUFIRCw4QkFHQztBQUVELFNBQVMsUUFBUSxDQUFDLFFBQWdCO0lBQ2hDLE9BQU8sTUFBTTtTQUNWLFVBQVUsQ0FBQyxRQUFRLENBQUM7U0FDcEIsTUFBTSxDQUFDLEVBQUUsQ0FBQyxZQUFZLENBQUMsUUFBUSxDQUFDLENBQUM7U0FDakMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDO0FBQ25CLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjcnlwdG8gZnJvbSAnY3J5cHRvJztcbmltcG9ydCAqIGFzIGZzIGZyb20gJ2ZzJztcbmltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5cbmV4cG9ydCBjb25zdCBBU1NFVF9GSUxFID0gcGF0aC5qb2luKF9fZGlybmFtZSwgJ2xheWVyLnppcCcpO1xuXG4vLyB3ZSBoYXNoIHRoZSBEb2NrZXJmaWxlIChpdCBjb250YWlucyB0aGUgdG9vbHMgdmVyc2lvbnMpIGJlY2F1c2UgaGFzaGluZyB0aGUgemlwIGlzIG5vbi1kZXRlcm1pbmlzdGljXG5leHBvcnQgZnVuY3Rpb24gYXNzZXRIYXNoKCkge1xuICAvLyBUaGlzIGNvdWxkIGJlIGNhbGN1bGF0ZWQgYXQgYnVpbGQgdGltZVxuICByZXR1cm4gaGFzaEZpbGUocGF0aC5qb2luKF9fZGlybmFtZSwgJy4uJywgJ2xheWVyJywgJ0RvY2tlcmZpbGUnKSk7XG59XG5cbmZ1bmN0aW9uIGhhc2hGaWxlKGZpbGVOYW1lOiBzdHJpbmcpIHtcbiAgcmV0dXJuIGNyeXB0b1xuICAgIC5jcmVhdGVIYXNoKCdzaGEyNTYnKVxuICAgIC51cGRhdGUoZnMucmVhZEZpbGVTeW5jKGZpbGVOYW1lKSlcbiAgICAuZGlnZXN0KCdoZXgnKTtcbn0iXX0=