/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as api from 'aws-cdk-lib/aws-apigateway';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as cloudfront from 'aws-cdk-lib/aws-cloudfront';
import * as logs from 'aws-cdk-lib/aws-logs';
import * as s3 from 'aws-cdk-lib/aws-s3';
import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
/**
 * @summary The properties for the CloudFrontToApiGatewayToLambda Construct
 */
export interface CloudFrontToApiGatewayToLambdaProps {
    /**
     * Existing instance of Lambda Function object, providing both this and `lambdaFunctionProps` will cause an error.
     *
     * @default - None
     */
    readonly existingLambdaObj?: lambda.Function;
    /**
     * Optional user provided props to override the default props for the Lambda function.
     *
     * @default - Default props are used
     */
    readonly lambdaFunctionProps?: lambda.FunctionProps;
    /**
     * Optional user provided props to override the default props for the API Gateway.
     *
     * @default - Default props are used
     */
    readonly apiGatewayProps?: api.LambdaRestApiProps | any;
    /**
     * Optional user provided props to override the default props.
     *
     * @default - Default props are used
     */
    readonly cloudFrontDistributionProps?: cloudfront.DistributionProps | any;
    /**
     * Optional user provided props to turn on/off the automatic injection of best practice HTTP security headers in all responses from cloudfront.
     *
     * @default - true
     */
    readonly insertHttpSecurityHeaders?: boolean;
    /**
     * Optional user provided props to override the default props for the CloudWatchLogs LogGroup.
     *
     * @default - Default props are used
     */
    readonly logGroupProps?: logs.LogGroupProps;
    /**
     * Optional user provided props to override the default props for the CloudFront Logging Bucket.
     *
     * @default - Default props are used
     */
    readonly cloudFrontLoggingBucketProps?: s3.BucketProps;
}
export declare class CloudFrontToApiGatewayToLambda extends Construct {
    readonly cloudFrontWebDistribution: cloudfront.Distribution;
    readonly cloudFrontFunction?: cloudfront.Function;
    readonly cloudFrontLoggingBucket?: s3.Bucket;
    readonly apiGateway: api.RestApi;
    readonly apiGatewayCloudWatchRole?: iam.Role;
    readonly apiGatewayLogGroup: logs.LogGroup;
    readonly lambdaFunction: lambda.Function;
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the CloudFrontToApiGatewayToLambda class.
     * @since 0.8.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: CloudFrontToApiGatewayToLambdaProps);
}
