"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontToApiGatewayToLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const aws_cloudfront_apigateway_1 = require("@aws-solutions-constructs/aws-cloudfront-apigateway");
class CloudFrontToApiGatewayToLambda extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the CloudFrontToApiGatewayToLambda class.
     * @param {Construct} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckLambdaProps(props);
        defaults.CheckApiProps(props);
        // CheckCloudFrontProps() is called by internal aws-cloudfront-apigateway construct
        if (!props.apiGatewayProps?.defaultMethodOptions?.authorizationType) {
            defaults.printWarning('As of v2.48.0, apiGatewayProps.defaultMethodOptions.authorizationType is\
      required. To update your instantiation call, add the following to your CloudFrontToApiGatewayToLambdaProps argument\
      \n\napiGatewayProps: { defaultMethodOptions: { authorizationType: api.AuthorizationType.NONE }},\n\nSee Issue1043 for an explanation.');
            throw new Error('As of v2.48.0, an explicit authorization type is required for CloudFront/API Gateway patterns');
        }
        else if (props.apiGatewayProps.defaultMethodOptions.authorizationType === "AWS_IAM") {
            throw new Error('Amazon API Gateway Rest APIs integrated with Amazon CloudFront do not support AWS_IAM authorization');
        }
        // All our tests are based upon this behavior being on, so we're setting
        // context here rather than assuming the client will set it
        this.node.setContext("@aws-cdk/aws-s3:serverAccessLogsUseBucketPolicy", true);
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps
        });
        // We can't default to IAM authentication with a CloudFront distribution, so
        // we'll instruct core to not use any default auth to avoid override warnings
        const regionalLambdaRestApiResponse = defaults.RegionalLambdaRestApi(this, this.lambdaFunction, props.apiGatewayProps, props.logGroupProps, props.createUsagePlan, false);
        this.apiGateway = regionalLambdaRestApiResponse.api;
        this.apiGatewayCloudWatchRole = regionalLambdaRestApiResponse.role;
        this.apiGatewayLogGroup = regionalLambdaRestApiResponse.group;
        const apiCloudfront = new aws_cloudfront_apigateway_1.CloudFrontToApiGateway(this, 'CloudFrontToApiGateway', {
            existingApiGatewayObj: this.apiGateway,
            cloudFrontDistributionProps: props.cloudFrontDistributionProps,
            insertHttpSecurityHeaders: props.insertHttpSecurityHeaders,
            cloudFrontLoggingBucketProps: props.cloudFrontLoggingBucketProps,
            responseHeadersPolicyProps: props.responseHeadersPolicyProps
        });
        this.cloudFrontWebDistribution = apiCloudfront.cloudFrontWebDistribution;
        this.cloudFrontFunction = apiCloudfront.cloudFrontFunction;
        this.cloudFrontLoggingBucket = apiCloudfront.cloudFrontLoggingBucket;
    }
}
exports.CloudFrontToApiGatewayToLambda = CloudFrontToApiGatewayToLambda;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontToApiGatewayToLambda[_a] = { fqn: "@aws-solutions-constructs/aws-cloudfront-apigateway-lambda.CloudFrontToApiGatewayToLambda", version: "2.85.3" };
//# sourceMappingURL=data:application/json;base64,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