/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as lambda from '@aws-cdk/aws-lambda';
import { DynamoEventSourceProps } from '@aws-cdk/aws-lambda-event-sources';
import * as dynamodb from '@aws-cdk/aws-dynamodb';
import { Construct } from '@aws-cdk/core';
/**
 * @summary The properties for the DynamoDBStreamToLambda Construct
 */
export interface DynamoDBStreamToLambdaProps {
    /**
     * Whether to create a new lambda function or use an existing lambda function.
     * If set to false, you must provide a lambda function object as `existingObj`
     *
     * @default - true
     */
    readonly deployLambda: boolean;
    /**
     * Existing instance of Lambda Function object.
     * If `deploy` is set to false only then this property is required
     *
     * @default - None
     */
    readonly existingLambdaObj?: lambda.Function;
    /**
     * Optional user provided props to override the default props.
     * If `deploy` is set to true only then this property is required
     *
     * @default - Default props are used
     */
    readonly lambdaFunctionProps?: lambda.FunctionProps;
    /**
     * Optional user provided props to override the default props
     *
     * @default - Default props are used
     */
    readonly dynamoTableProps?: dynamodb.TableProps;
    /**
     * Existing instance of DynamoDB table object, If this is set then the dynamoTableProps is ignored
     *
     * @default - None
     */
    readonly existingTableObj?: dynamodb.Table;
    /**
     * Optional user provided props to override the default props
     *
     * @default - Default props are used
     */
    readonly dynamoEventSourceProps?: DynamoEventSourceProps;
}
export declare class DynamoDBStreamToLambda extends Construct {
    readonly lambdaFunction: lambda.Function;
    readonly dynamoTable: dynamodb.Table;
    /**
     * @summary Constructs a new instance of the LambdaToDynamoDB class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {DynamoDBStreamToLambdaProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: DynamoDBStreamToLambdaProps);
}
