/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as events from 'aws-cdk-lib/aws-events';
import { Construct } from 'constructs';
/**
 * @summary The properties for the CloudFrontToApiGateway Construct
 */
export interface EventbridgeToLambdaProps {
    /**
     * Optional - instance of an existing Lambda Function object, providing both this and `lambdaFunctionProps` will cause an error.
     *
     * @default - None
     */
    readonly existingLambdaObj?: lambda.Function;
    /**
     * Optional - user provided props to override the default props for the Lambda function. Providing both this and `existingLambdaObj`
     * causes an error.
     *
     * @default - Default props are used
     */
    readonly lambdaFunctionProps?: lambda.FunctionProps;
    /**
     * Optional - user provided custom EventBus for this construct to use. Providing both this and `eventBusProps`
     * causes an error.
     *
     * @default - None
     */
    readonly existingEventBusInterface?: events.IEventBus;
    /**
     * Optional - user provided properties to override the default properties when creating a custom EventBus. Setting
     * this value to `{}` will create a custom EventBus using all default properties. If neither this nor
     * `existingEventBusInterface` is provided the construct will use the default EventBus. Providing both this and
     * `existingEventBusInterface` causes an error.
     *
     * @default - None
     */
    readonly eventBusProps?: events.EventBusProps;
    /**
     * User provided eventRuleProps to override the defaults
     *
     * @default - None
     */
    readonly eventRuleProps: events.RuleProps;
}
export declare class EventbridgeToLambda extends Construct {
    readonly lambdaFunction: lambda.Function;
    readonly eventBus?: events.IEventBus;
    readonly eventsRule: events.Rule;
    /**
     * @summary Constructs a new instance of the EventbridgeToLambda class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {EventbridgeToLambdaProps} props - user provided props for the construct
     * @access public
     */
    constructor(scope: Construct, id: string, props: EventbridgeToLambdaProps);
}
