"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotToLambdaToDynamoDB = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iot_lambda_1 = require("@aws-solutions-constructs/aws-iot-lambda");
const aws_lambda_dynamodb_1 = require("@aws-solutions-constructs/aws-lambda-dynamodb");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
class IotToLambdaToDynamoDB extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the IotToLambdaToDynamoDB class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {IotToLambdaToDynamoDBProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        // Other permissions for constructs are accepted as arrays, turning tablePermissions into
        // an array to use the same validation function.
        if (props.tablePermissions) {
            defaults.CheckListValues(['All', 'Read', 'ReadWrite', 'Write'], [props.tablePermissions], 'table permission');
        }
        // Setup the LambdaToDynamoDB
        const lambdaToDynamoDB = new aws_lambda_dynamodb_1.LambdaToDynamoDB(this, 'LambdaToDynamoDB', {
            tablePermissions: props.tablePermissions,
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            dynamoTableProps: props.dynamoTableProps,
            tableEnvironmentVariableName: props.tableEnvironmentVariableName,
            existingVpc: props.existingVpc,
            deployVpc: props.deployVpc,
            vpcProps: props.vpcProps,
        });
        this.dynamoTable = lambdaToDynamoDB.dynamoTable;
        this.vpc = lambdaToDynamoDB.vpc;
        // Setup the IotToLambda
        const iotToLambda = new aws_iot_lambda_1.IotToLambda(this, 'IotToLambda', {
            existingLambdaObj: lambdaToDynamoDB.lambdaFunction,
            iotTopicRuleProps: props.iotTopicRuleProps
        });
        this.iotTopicRule = iotToLambda.iotTopicRule;
        this.lambdaFunction = iotToLambda.lambdaFunction;
    }
}
exports.IotToLambdaToDynamoDB = IotToLambdaToDynamoDB;
_a = JSII_RTTI_SYMBOL_1;
IotToLambdaToDynamoDB[_a] = { fqn: "@aws-solutions-constructs/aws-iot-lambda-dynamodb.IotToLambdaToDynamoDB", version: "2.78.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQWlCQSw2RUFBdUU7QUFDdkUsdUZBQWlGO0FBQ2pGLHdGQUF3RjtBQUN4RiwyQ0FBdUM7QUFDdkMsMkRBQTJEO0FBMkQzRCxNQUFhLHFCQUFzQixTQUFRLHNCQUFTO0lBTWxEOzs7Ozs7O09BT0c7SUFDSCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQWlDO1FBQ3pFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIseUZBQXlGO1FBQ3pGLGdEQUFnRDtRQUNoRCxJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO1lBQzNCLFFBQVEsQ0FBQyxlQUFlLENBQUMsQ0FBQyxLQUFLLEVBQUUsTUFBTSxFQUFFLFdBQVcsRUFBRSxPQUFPLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxFQUFFLGtCQUFrQixDQUFDLENBQUM7UUFDaEgsQ0FBQztRQUVELDZCQUE2QjtRQUM3QixNQUFNLGdCQUFnQixHQUFHLElBQUksc0NBQWdCLENBQUMsSUFBSSxFQUFFLGtCQUFrQixFQUFFO1lBQ3RFLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxnQkFBZ0I7WUFDeEMsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQjtZQUMxQyxtQkFBbUIsRUFBRSxLQUFLLENBQUMsbUJBQW1CO1lBQzlDLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxnQkFBZ0I7WUFDeEMsNEJBQTRCLEVBQUUsS0FBSyxDQUFDLDRCQUE0QjtZQUNoRSxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTO1lBQzFCLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUTtTQUN6QixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsV0FBVyxHQUFHLGdCQUFnQixDQUFDLFdBQVcsQ0FBQztRQUNoRCxJQUFJLENBQUMsR0FBRyxHQUFHLGdCQUFnQixDQUFDLEdBQUcsQ0FBQztRQUVoQyx3QkFBd0I7UUFDeEIsTUFBTSxXQUFXLEdBQUcsSUFBSSw0QkFBVyxDQUFDLElBQUksRUFBRSxhQUFhLEVBQUU7WUFDdkQsaUJBQWlCLEVBQUUsZ0JBQWdCLENBQUMsY0FBYztZQUNsRCxpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCO1NBQzNDLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxZQUFZLEdBQUcsV0FBVyxDQUFDLFlBQVksQ0FBQztRQUM3QyxJQUFJLENBQUMsY0FBYyxHQUFHLFdBQVcsQ0FBQyxjQUFjLENBQUM7SUFDbkQsQ0FBQzs7QUE1Q0gsc0RBNkNDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiAgQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqICB3aXRoIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogIG9yIGluIHRoZSAnbGljZW5zZScgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gJ0FTIElTJyBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTXG4gKiAgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqICBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ2F3cy1jZGstbGliL2F3cy1sYW1iZGEnO1xuaW1wb3J0ICogYXMgaW90IGZyb20gJ2F3cy1jZGstbGliL2F3cy1pb3QnO1xuaW1wb3J0ICogYXMgZWMyIGZyb20gJ2F3cy1jZGstbGliL2F3cy1lYzInO1xuaW1wb3J0ICogYXMgZHluYW1vZGIgZnJvbSAnYXdzLWNkay1saWIvYXdzLWR5bmFtb2RiJztcbmltcG9ydCB7IElvdFRvTGFtYmRhIH0gZnJvbSAnQGF3cy1zb2x1dGlvbnMtY29uc3RydWN0cy9hd3MtaW90LWxhbWJkYSc7XG5pbXBvcnQgeyBMYW1iZGFUb0R5bmFtb0RCIH0gZnJvbSAnQGF3cy1zb2x1dGlvbnMtY29uc3RydWN0cy9hd3MtbGFtYmRhLWR5bmFtb2RiJztcbi8vIE5vdGU6IFRvIGVuc3VyZSBDREt2MiBjb21wYXRpYmlsaXR5LCBrZWVwIHRoZSBpbXBvcnQgc3RhdGVtZW50IGZvciBDb25zdHJ1Y3Qgc2VwYXJhdGVcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgZGVmYXVsdHMgZnJvbSAnQGF3cy1zb2x1dGlvbnMtY29uc3RydWN0cy9jb3JlJztcblxuLyoqXG4gKiBAc3VtbWFyeSBUaGUgcHJvcGVydGllcyBmb3IgdGhlIElvdFRvTGFtYmRhVG9EeW5hbW9EQiBjbGFzcy5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJb3RUb0xhbWJkYVRvRHluYW1vREJQcm9wcyB7XG4gIC8qKlxuICAgKiBFeGlzdGluZyBpbnN0YW5jZSBvZiBMYW1iZGEgRnVuY3Rpb24gb2JqZWN0LCBwcm92aWRpbmcgYm90aCB0aGlzIGFuZCBgbGFtYmRhRnVuY3Rpb25Qcm9wc2Agd2lsbCBjYXVzZSBhbiBlcnJvci5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBOb25lXG4gICAqL1xuICByZWFkb25seSBleGlzdGluZ0xhbWJkYU9iaj86IGxhbWJkYS5GdW5jdGlvbixcbiAgLyoqXG4gICAqIFVzZXIgcHJvdmlkZWQgcHJvcHMgdG8gb3ZlcnJpZGUgdGhlIGRlZmF1bHQgcHJvcHMgZm9yIHRoZSBMYW1iZGEgZnVuY3Rpb24uXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gRGVmYXVsdCBwcm9wcyBhcmUgdXNlZFxuICAgKi9cbiAgcmVhZG9ubHkgbGFtYmRhRnVuY3Rpb25Qcm9wcz86IGxhbWJkYS5GdW5jdGlvblByb3BzLFxuICAvKipcbiAgICogVXNlciBwcm92aWRlZCBwcm9wcyB0byBvdmVycmlkZSB0aGUgZGVmYXVsdCBwcm9wc1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIERlZmF1bHQgcHJvcHMgYXJlIHVzZWRcbiAgICovXG4gIHJlYWRvbmx5IGlvdFRvcGljUnVsZVByb3BzOiBpb3QuQ2ZuVG9waWNSdWxlUHJvcHMsXG4gIC8qKlxuICAgKiBPcHRpb25hbCB1c2VyIHByb3ZpZGVkIHByb3BzIHRvIG92ZXJyaWRlIHRoZSBkZWZhdWx0IHByb3BzXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gRGVmYXVsdCBwcm9wcyBhcmUgdXNlZFxuICAgKi9cbiAgcmVhZG9ubHkgZHluYW1vVGFibGVQcm9wcz86IGR5bmFtb2RiLlRhYmxlUHJvcHMsXG4gIC8qKlxuICAgKiBPcHRpb25hbCB0YWJsZSBwZXJtaXNzaW9ucyB0byBncmFudCB0byB0aGUgTGFtYmRhIGZ1bmN0aW9uLlxuICAgKiBPbmUgb2YgdGhlIGZvbGxvd2luZyBtYXkgYmUgc3BlY2lmaWVkOiBcIkFsbFwiLCBcIlJlYWRcIiwgXCJSZWFkV3JpdGVcIiwgXCJXcml0ZVwiLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIFJlYWQvd3JpdGUgYWNjZXNzIGlzIGdpdmVuIHRvIHRoZSBMYW1iZGEgZnVuY3Rpb24gaWYgbm8gdmFsdWUgaXMgc3BlY2lmaWVkLlxuICAgKi9cbiAgcmVhZG9ubHkgdGFibGVQZXJtaXNzaW9ucz86IHN0cmluZyxcbiAgLyoqXG4gICAqIE9wdGlvbmFsIE5hbWUgZm9yIHRoZSBMYW1iZGEgZnVuY3Rpb24gZW52aXJvbm1lbnQgdmFyaWFibGUgc2V0IHRvIHRoZSBuYW1lIG9mIHRoZSBEeW5hbW9EQiB0YWJsZS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBEREJfVEFCTEVfTkFNRVxuICAgKi9cbiAgcmVhZG9ubHkgdGFibGVFbnZpcm9ubWVudFZhcmlhYmxlTmFtZT86IHN0cmluZztcbiAgLyoqXG4gICAqIEFuIGV4aXN0aW5nIFZQQyBmb3IgdGhlIGNvbnN0cnVjdCB0byB1c2UgKGNvbnN0cnVjdCB3aWxsIE5PVCBjcmVhdGUgYSBuZXcgVlBDIGluIHRoaXMgY2FzZSlcbiAgICovXG4gIHJlYWRvbmx5IGV4aXN0aW5nVnBjPzogZWMyLklWcGM7XG4gIC8qKlxuICAgKiBQcm9wZXJ0aWVzIHRvIG92ZXJyaWRlIGRlZmF1bHQgcHJvcGVydGllcyBpZiBkZXBsb3lWcGMgaXMgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgdnBjUHJvcHM/OiBlYzIuVnBjUHJvcHM7XG4gIC8qKlxuICAgKiBXaGV0aGVyIHRvIGRlcGxveSBhIG5ldyBWUENcbiAgICpcbiAgICogQGRlZmF1bHQgLSBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgZGVwbG95VnBjPzogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGNsYXNzIElvdFRvTGFtYmRhVG9EeW5hbW9EQiBleHRlbmRzIENvbnN0cnVjdCB7XG4gIHB1YmxpYyByZWFkb25seSBpb3RUb3BpY1J1bGU6IGlvdC5DZm5Ub3BpY1J1bGU7XG4gIHB1YmxpYyByZWFkb25seSBsYW1iZGFGdW5jdGlvbjogbGFtYmRhLkZ1bmN0aW9uO1xuICBwdWJsaWMgcmVhZG9ubHkgZHluYW1vVGFibGU6IGR5bmFtb2RiLlRhYmxlO1xuICBwdWJsaWMgcmVhZG9ubHkgdnBjPzogZWMyLklWcGM7XG5cbiAgLyoqXG4gICAqIEBzdW1tYXJ5IENvbnN0cnVjdHMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhlIElvdFRvTGFtYmRhVG9EeW5hbW9EQiBjbGFzcy5cbiAgICogQHBhcmFtIHtjZGsuQXBwfSBzY29wZSAtIHJlcHJlc2VudHMgdGhlIHNjb3BlIGZvciBhbGwgdGhlIHJlc291cmNlcy5cbiAgICogQHBhcmFtIHtzdHJpbmd9IGlkIC0gdGhpcyBpcyBhIGEgc2NvcGUtdW5pcXVlIGlkLlxuICAgKiBAcGFyYW0ge0lvdFRvTGFtYmRhVG9EeW5hbW9EQlByb3BzfSBwcm9wcyAtIHVzZXIgcHJvdmlkZWQgcHJvcHMgZm9yIHRoZSBjb25zdHJ1Y3RcbiAgICogQHNpbmNlIDAuOC4wXG4gICAqIEBhY2Nlc3MgcHVibGljXG4gICAqL1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogSW90VG9MYW1iZGFUb0R5bmFtb0RCUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgLy8gT3RoZXIgcGVybWlzc2lvbnMgZm9yIGNvbnN0cnVjdHMgYXJlIGFjY2VwdGVkIGFzIGFycmF5cywgdHVybmluZyB0YWJsZVBlcm1pc3Npb25zIGludG9cbiAgICAvLyBhbiBhcnJheSB0byB1c2UgdGhlIHNhbWUgdmFsaWRhdGlvbiBmdW5jdGlvbi5cbiAgICBpZiAocHJvcHMudGFibGVQZXJtaXNzaW9ucykge1xuICAgICAgZGVmYXVsdHMuQ2hlY2tMaXN0VmFsdWVzKFsnQWxsJywgJ1JlYWQnLCAnUmVhZFdyaXRlJywgJ1dyaXRlJ10sIFtwcm9wcy50YWJsZVBlcm1pc3Npb25zXSwgJ3RhYmxlIHBlcm1pc3Npb24nKTtcbiAgICB9XG5cbiAgICAvLyBTZXR1cCB0aGUgTGFtYmRhVG9EeW5hbW9EQlxuICAgIGNvbnN0IGxhbWJkYVRvRHluYW1vREIgPSBuZXcgTGFtYmRhVG9EeW5hbW9EQih0aGlzLCAnTGFtYmRhVG9EeW5hbW9EQicsIHtcbiAgICAgIHRhYmxlUGVybWlzc2lvbnM6IHByb3BzLnRhYmxlUGVybWlzc2lvbnMsXG4gICAgICBleGlzdGluZ0xhbWJkYU9iajogcHJvcHMuZXhpc3RpbmdMYW1iZGFPYmosXG4gICAgICBsYW1iZGFGdW5jdGlvblByb3BzOiBwcm9wcy5sYW1iZGFGdW5jdGlvblByb3BzLFxuICAgICAgZHluYW1vVGFibGVQcm9wczogcHJvcHMuZHluYW1vVGFibGVQcm9wcyxcbiAgICAgIHRhYmxlRW52aXJvbm1lbnRWYXJpYWJsZU5hbWU6IHByb3BzLnRhYmxlRW52aXJvbm1lbnRWYXJpYWJsZU5hbWUsXG4gICAgICBleGlzdGluZ1ZwYzogcHJvcHMuZXhpc3RpbmdWcGMsXG4gICAgICBkZXBsb3lWcGM6IHByb3BzLmRlcGxveVZwYyxcbiAgICAgIHZwY1Byb3BzOiBwcm9wcy52cGNQcm9wcyxcbiAgICB9KTtcbiAgICB0aGlzLmR5bmFtb1RhYmxlID0gbGFtYmRhVG9EeW5hbW9EQi5keW5hbW9UYWJsZTtcbiAgICB0aGlzLnZwYyA9IGxhbWJkYVRvRHluYW1vREIudnBjO1xuXG4gICAgLy8gU2V0dXAgdGhlIElvdFRvTGFtYmRhXG4gICAgY29uc3QgaW90VG9MYW1iZGEgPSBuZXcgSW90VG9MYW1iZGEodGhpcywgJ0lvdFRvTGFtYmRhJywge1xuICAgICAgZXhpc3RpbmdMYW1iZGFPYmo6IGxhbWJkYVRvRHluYW1vREIubGFtYmRhRnVuY3Rpb24sXG4gICAgICBpb3RUb3BpY1J1bGVQcm9wczogcHJvcHMuaW90VG9waWNSdWxlUHJvcHNcbiAgICB9KTtcbiAgICB0aGlzLmlvdFRvcGljUnVsZSA9IGlvdFRvTGFtYmRhLmlvdFRvcGljUnVsZTtcbiAgICB0aGlzLmxhbWJkYUZ1bmN0aW9uID0gaW90VG9MYW1iZGEubGFtYmRhRnVuY3Rpb247XG4gIH1cbn0iXX0=