"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotToLambdaToDynamoDB = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iot_lambda_1 = require("@aws-solutions-constructs/aws-iot-lambda");
const aws_lambda_dynamodb_1 = require("@aws-solutions-constructs/aws-lambda-dynamodb");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
class IotToLambdaToDynamoDB extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the IotToLambdaToDynamoDB class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {IotToLambdaToDynamoDBProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        // Other permissions for constructs are accepted as arrays, turning tablePermissions into
        // an array to use the same validation function.
        if (props.tablePermissions) {
            defaults.CheckListValues(['All', 'Read', 'ReadWrite', 'Write'], [props.tablePermissions], 'table permission');
        }
        // Setup the LambdaToDynamoDB
        const lambdaToDynamoDB = new aws_lambda_dynamodb_1.LambdaToDynamoDB(this, 'LambdaToDynamoDB', {
            tablePermissions: props.tablePermissions,
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            dynamoTableProps: props.dynamoTableProps,
            tableEnvironmentVariableName: props.tableEnvironmentVariableName,
            existingVpc: props.existingVpc,
            deployVpc: props.deployVpc,
            vpcProps: props.vpcProps,
        });
        this.dynamoTable = lambdaToDynamoDB.dynamoTable;
        this.vpc = lambdaToDynamoDB.vpc;
        // Setup the IotToLambda
        const iotToLambda = new aws_iot_lambda_1.IotToLambda(this, 'IotToLambda', {
            existingLambdaObj: lambdaToDynamoDB.lambdaFunction,
            iotTopicRuleProps: props.iotTopicRuleProps
        });
        this.iotTopicRule = iotToLambda.iotTopicRule;
        this.lambdaFunction = iotToLambda.lambdaFunction;
    }
}
exports.IotToLambdaToDynamoDB = IotToLambdaToDynamoDB;
_a = JSII_RTTI_SYMBOL_1;
IotToLambdaToDynamoDB[_a] = { fqn: "@aws-solutions-constructs/aws-iot-lambda-dynamodb.IotToLambdaToDynamoDB", version: "2.98.0" };
//# sourceMappingURL=data:application/json;base64,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