"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotToLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iot = require("aws-cdk-lib/aws-iot");
const iam = require("aws-cdk-lib/aws-iam");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-solutions-constructs/core");
class IotToLambda extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the IotToLambda class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {IotToLambdaProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckLambdaProps(props);
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps
        });
        const defaultIotTopicProps = defaults.DefaultCfnTopicRuleProps([{
                lambda: {
                    functionArn: this.lambdaFunction.functionArn
                }
            }]);
        const iotTopicProps = (0, core_1.overrideProps)(defaultIotTopicProps, props.iotTopicRuleProps, true);
        // Create the IoT topic rule
        this.iotTopicRule = new iot.CfnTopicRule(this, 'IotTopic', iotTopicProps);
        defaults.addPermission(this.lambdaFunction, "AwsIotLambdaInvokePermission", {
            principal: new iam.ServicePrincipal('iot.amazonaws.com'),
            sourceArn: this.iotTopicRule.attrArn
        });
    }
}
exports.IotToLambda = IotToLambda;
_a = JSII_RTTI_SYMBOL_1;
IotToLambda[_a] = { fqn: "@aws-solutions-constructs/aws-iot-lambda.IotToLambda", version: "2.98.0" };
//# sourceMappingURL=data:application/json;base64,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