"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaToElasticachememcached = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("../../core");
const constructs_1 = require("constructs");
const core_1 = require("../../core");
const defaultEnvironmentVariableName = "CACHE_ENDPOINT";
/**
 * @summary The LambdaToElasticachememcached class.
 */
class LambdaToElasticachememcached extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToElasticachememcached class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {LambdaToElasticachememcachedProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckVpcProps(props);
        defaults.CheckLambdaProps(props);
        if ((props.existingCache || props.existingLambdaObj) && (!props.existingVpc)) {
            throw Error('If providing an existing Cache or Lambda Function, you must also supply the associated existingVpc');
        }
        if (props.cacheProps &&
            props.cacheProps.engine &&
            props.cacheProps.engine !== "memcached") {
            throw Error("This construct can only launch memcached clusters");
        }
        if (props.cacheProps && props.existingCache) {
            throw Error("Cannot specify existingCache and cacheProps");
        }
        const cachePort = (0, core_1.getCachePort)(props.cacheProps, props.existingCache);
        this.vpc = defaults.buildVpc(scope, {
            defaultVpcProps: defaults.DefaultIsolatedVpcProps(),
            existingVpc: props.existingVpc,
            userVpcProps: props.vpcProps,
        });
        const lambdaToCacheSecurityGroup = (0, core_1.CreateSelfReferencingSecurityGroup)(this, id, this.vpc, cachePort);
        this.cache = (0, core_1.obtainMemcachedCluster)(this, id, {
            cacheSecurityGroupId: lambdaToCacheSecurityGroup.securityGroupId,
            cacheProps: props.cacheProps,
            existingCache: props.existingCache,
            vpc: this.vpc,
            cachePort,
        });
        // Add the self-referencing security group to the Lambda function props
        const lambdaFunctionProps = defaults.consolidateProps({}, props.lambdaFunctionProps, { securityGroups: [lambdaToCacheSecurityGroup] }, true);
        // Setup the Lambda function
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps,
            vpc: this.vpc,
        });
        AddLambdaEnvironmentVariable(this.lambdaFunction, `${this.cache.attrConfigurationEndpointAddress}:${this.cache.attrConfigurationEndpointPort}`, defaultEnvironmentVariableName, props.cacheEndpointEnvironmentVariableName);
    }
}
exports.LambdaToElasticachememcached = LambdaToElasticachememcached;
_a = JSII_RTTI_SYMBOL_1;
LambdaToElasticachememcached[_a] = { fqn: "@aws-solutions-constructs/aws-lambda-elasticachememcached.LambdaToElasticachememcached", version: "2.98.0" };
function AddLambdaEnvironmentVariable(targetFunction, value, defaultName, clientName) {
    const variableName = clientName || defaultName;
    targetFunction.addEnvironment(variableName, value);
}
//# sourceMappingURL=data:application/json;base64,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