"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaToOpenSearch = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
class LambdaToOpenSearch extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToOpenSearch class.
     * @param {Construct} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {LambdaToOpenSearchProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckVpcProps(props);
        defaults.CheckLambdaProps(props);
        defaults.CheckOpenSearchProps(props);
        if (props.vpcProps && !props.deployVpc) {
            throw new Error("Error - deployVpc must be true when defining vpcProps");
        }
        if (props.lambdaFunctionProps?.vpc || props.lambdaFunctionProps?.vpcSubnets) {
            throw new Error("Error - Define VPC using construct parameters not Lambda function props");
        }
        if (props.deployVpc || props.existingVpc) {
            this.vpc = defaults.buildVpc(scope, {
                defaultVpcProps: defaults.DefaultIsolatedVpcProps(),
                existingVpc: props.existingVpc,
                userVpcProps: props.vpcProps,
                constructVpcProps: {
                    enableDnsHostnames: true,
                    enableDnsSupport: true,
                },
            });
        }
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            vpc: this.vpc
        });
        // Find the lambda service Role ARN
        const lambdaFunctionRoleARN = this.lambdaFunction.role?.roleArn;
        let cognitoAuthorizedRole;
        [this.userPool, this.userPoolClient, this.identityPool, cognitoAuthorizedRole] =
            defaults.buildCognitoForSearchService(this, props.cognitoDomainName ?? props.openSearchDomainName);
        let securityGroupIds;
        if (this.vpc) {
            securityGroupIds = defaults.getLambdaVpcSecurityGroupIds(this.lambdaFunction);
        }
        const buildOpenSearchProps = {
            userpool: this.userPool,
            identitypool: this.identityPool,
            cognitoAuthorizedRoleARN: cognitoAuthorizedRole.roleArn,
            serviceRoleARN: lambdaFunctionRoleARN,
            vpc: this.vpc,
            openSearchDomainName: props.openSearchDomainName,
            clientDomainProps: props.openSearchDomainProps,
            securityGroupIds
        };
        const buildOpenSearchResponse = defaults.buildOpenSearch(this, buildOpenSearchProps);
        this.openSearchDomain = buildOpenSearchResponse.domain;
        this.openSearchRole = buildOpenSearchResponse.role;
        if (props.createCloudWatchAlarms === undefined || props.createCloudWatchAlarms) {
            this.cloudWatchAlarms = defaults.buildOpenSearchCWAlarms(this);
        }
        const domainEndpointEnvironmentVariableName = props.domainEndpointEnvironmentVariableName || 'DOMAIN_ENDPOINT';
        this.lambdaFunction.addEnvironment(domainEndpointEnvironmentVariableName, this.openSearchDomain.attrDomainEndpoint);
    }
}
exports.LambdaToOpenSearch = LambdaToOpenSearch;
_a = JSII_RTTI_SYMBOL_1;
LambdaToOpenSearch[_a] = { fqn: "@aws-solutions-constructs/aws-lambda-opensearch.LambdaToOpenSearch", version: "2.69.0" };
//# sourceMappingURL=data:application/json;base64,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