"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaToSns = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
/**
 * @summary The LambdaToSns class.
 */
class LambdaToSns extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToSns class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {LambdaToSnsProps} props - user provided props for the construct.
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckSnsProps(props);
        defaults.CheckVpcProps(props);
        defaults.CheckLambdaProps(props);
        if (props.deployVpc || props.existingVpc) {
            this.vpc = defaults.buildVpc(scope, {
                defaultVpcProps: defaults.DefaultIsolatedVpcProps(),
                existingVpc: props.existingVpc,
                userVpcProps: props.vpcProps,
                constructVpcProps: {
                    enableDnsHostnames: true,
                    enableDnsSupport: true,
                },
            });
            defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.SNS);
        }
        // Setup the Lambda function
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            vpc: this.vpc,
        });
        // Setup the SNS topic
        const buildTopicResponse = defaults.buildTopic(this, id, {
            existingTopicObj: props.existingTopicObj,
            topicProps: props.topicProps,
            enableEncryptionWithCustomerManagedKey: props.enableEncryptionWithCustomerManagedKey,
            encryptionKey: props.encryptionKey,
            encryptionKeyProps: props.encryptionKeyProps
        });
        this.snsTopic = buildTopicResponse.topic;
        // Configure environment variables
        const topicArnEnvironmentVariableName = props.topicArnEnvironmentVariableName || 'SNS_TOPIC_ARN';
        this.lambdaFunction.addEnvironment(topicArnEnvironmentVariableName, this.snsTopic.topicArn);
        const topicNameEnvironmentVariableName = props.topicNameEnvironmentVariableName || 'SNS_TOPIC_NAME';
        this.lambdaFunction.addEnvironment(topicNameEnvironmentVariableName, this.snsTopic.topicName);
        // Add publishing permissions to the function
        this.snsTopic.grantPublish(this.lambdaFunction.grantPrincipal);
    }
}
exports.LambdaToSns = LambdaToSns;
_a = JSII_RTTI_SYMBOL_1;
LambdaToSns[_a] = { fqn: "@aws-solutions-constructs/aws-lambda-sns.LambdaToSns", version: "2.97.0" };
//# sourceMappingURL=data:application/json;base64,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