"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaToSqsToLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_lambda_sqs_1 = require("@aws-solutions-constructs/aws-lambda-sqs");
const aws_sqs_lambda_1 = require("@aws-solutions-constructs/aws-sqs-lambda");
const core_1 = require("@aws-cdk/core");
const defaults = require("@aws-solutions-constructs/core");
/**
 * @summary The LambdaToSqsToLambda class.
 */
class LambdaToSqsToLambda extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the LambdaToSqsToLambda class.
     * @since 1.53.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Setup the aws-lambda-sqs pattern
        const lambdaToSqs = new aws_lambda_sqs_1.LambdaToSqs(this, 'lambda-to-sqs', {
            existingLambdaObj: props.existingProducerLambdaObj,
            lambdaFunctionProps: props.producerLambdaFunctionProps,
            existingQueueObj: props.existingQueueObj,
            queueProps: props.queueProps,
            deadLetterQueueProps: props.deadLetterQueueProps,
            deployDeadLetterQueue: props.deployDeadLetterQueue,
            maxReceiveCount: props.maxReceiveCount,
            queueEnvironmentVariableName: props.queueEnvironmentVariableName
        });
        // Set the queue as a pattern property
        this.sqsQueue = lambdaToSqs.sqsQueue;
        // Setup the aws-sqs-lambda pattern
        const sqsToLambda = new aws_sqs_lambda_1.SqsToLambda(this, 'sqs-to-lambda', {
            existingLambdaObj: props.existingConsumerLambdaObj,
            lambdaFunctionProps: props.consumerLambdaFunctionProps,
            existingQueueObj: this.sqsQueue,
            deployDeadLetterQueue: false
        });
        // Set other relevant pattern properties
        this.producerLambdaFunction = lambdaToSqs.lambdaFunction;
        this.deadLetterQueue = lambdaToSqs.deadLetterQueue;
        this.consumerLambdaFunction = sqsToLambda.lambdaFunction;
    }
}
exports.LambdaToSqsToLambda = LambdaToSqsToLambda;
_a = JSII_RTTI_SYMBOL_1;
LambdaToSqsToLambda[_a] = { fqn: "@aws-solutions-constructs/aws-lambda-sqs-lambda.LambdaToSqsToLambda", version: "1.114.0" };
//# sourceMappingURL=data:application/json;base64,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