import json
import setuptools

kwargs = json.loads(
    """
{
    "name": "aws-solutions-constructs.aws-lambda-sqs-lambda",
    "version": "1.154.0",
    "description": "CDK construct that provisions (1) an AWS Lambda function that is configured to send messages to a queue; (2) an Amazon SQS queue; and (3) an AWS Lambda function configured to consume messages from the queue.",
    "license": "Apache-2.0",
    "url": "https://github.com/awslabs/aws-solutions-constructs.git",
    "long_description_content_type": "text/markdown",
    "author": "Amazon Web Services",
    "bdist_wheel": {
        "universal": true
    },
    "project_urls": {
        "Source": "https://github.com/awslabs/aws-solutions-constructs.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "aws_solutions_constructs.aws_lambda_sqs_lambda",
        "aws_solutions_constructs.aws_lambda_sqs_lambda._jsii"
    ],
    "package_data": {
        "aws_solutions_constructs.aws_lambda_sqs_lambda._jsii": [
            "aws-lambda-sqs-lambda@1.154.0.jsii.tgz"
        ],
        "aws_solutions_constructs.aws_lambda_sqs_lambda": [
            "py.typed"
        ]
    },
    "python_requires": "~=3.7",
    "install_requires": [
        "aws-cdk.aws-ec2==1.154.0",
        "aws-cdk.aws-lambda-event-sources==1.154.0",
        "aws-cdk.aws-lambda==1.154.0",
        "aws-cdk.aws-sqs==1.154.0",
        "aws-cdk.core==1.154.0",
        "aws-solutions-constructs.aws-lambda-sqs==1.154.0",
        "aws-solutions-constructs.aws-sqs-lambda==1.154.0",
        "aws-solutions-constructs.core==1.154.0",
        "constructs>=3.2.0, <4.0.0",
        "jsii>=1.58.0, <2.0.0",
        "publication>=0.0.3"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Typing :: Typed",
        "License :: OSI Approved"
    ],
    "scripts": []
}
"""
)

with open("README.md", encoding="utf8") as fp:
    kwargs["long_description"] = fp.read()


setuptools.setup(**kwargs)
