/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as lambda from "aws-cdk-lib/aws-lambda";
import * as ssm from "aws-cdk-lib/aws-ssm";
import * as ec2 from "aws-cdk-lib/aws-ec2";
import { Construct } from "constructs";
/**
 * @summary The properties for the LambdaToSsmstringparameter class.
 */
export interface LambdaToSsmstringparameterProps {
    /**
     * Optional - instance of an existing Lambda Function object, providing both this and `lambdaFunctionProps` will cause an error.
     *
     * @default - None
     */
    readonly existingLambdaObj?: lambda.Function;
    /**
     * Optional - user provided props to override the default props for the Lambda function. Providing both this and `existingLambdaObj` is an error.
     *
     * @default - Default properties are used.
     */
    readonly lambdaFunctionProps?: lambda.FunctionProps;
    /**
     * Existing instance of SSM String parameter object, If this is set then the stringParameterProps is ignored.
     *
     * @default - Default props are used
     */
    readonly existingStringParameterObj?: ssm.StringParameter;
    /**
     * Optional user provided props to override the default props for SSM String parameter. If existingStringParameterObj
     * is not set stringParameterProps is required. The only supported string parameter type is ParameterType.STRING.
     *
     * @default - Default props are used
     */
    readonly stringParameterProps?: ssm.StringParameterProps;
    /**
     * An existing VPC for the construct to use (construct will NOT create a new VPC in this case)
     */
    readonly existingVpc?: ec2.IVpc;
    /**
     * Properties to override default properties if deployVpc is true
     */
    readonly vpcProps?: ec2.VpcProps;
    /**
     * Whether to deploy a new VPC
     *
     * @default - false
     */
    readonly deployVpc?: boolean;
    /**
     * Optional Name for the Lambda function environment variable set to the name of the parameter.
     *
     * @default - SSM_STRING_PARAMETER_NAME
     */
    readonly stringParameterEnvironmentVariableName?: string;
    /**
     * Optional SSM String parameter permissions to grant to the Lambda function.
     * One of the following may be specified: "Read", "ReadWrite".
     *
     * @default - Read access is given to the Lambda function if no value is specified.
     */
    readonly stringParameterPermissions?: string;
}
/**
 * @summary The LambdaToSsmstringparameter class.
 */
export declare class LambdaToSsmstringparameter extends Construct {
    readonly lambdaFunction: lambda.Function;
    readonly stringParameter: ssm.StringParameter;
    readonly vpc?: ec2.IVpc;
    /**
     * @summary Constructs a new instance of the LambdaToSsmstringparameter class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {LambdaToSsmstringparameterProps} props - user provided props for the construct.
     * @since 1.49.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: LambdaToSsmstringparameterProps);
}
