"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const sftasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const core_1 = require("@aws-solutions-constructs/core");
const integ_tests_alpha_1 = require("@aws-cdk/integ-tests-alpha");
const defaults = require("@aws-solutions-constructs/core");
// Setup the app and stack
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, (0, core_1.generateIntegStackName)(__filename));
const functionOne = (0, core_1.deployLambdaFunction)(stack, {
    runtime: defaults.COMMERCIAL_REGION_LAMBDA_NODE_RUNTIME,
    handler: 'index.handler',
    code: lambda.Code.fromInline(`exports.handler = async (event) => { console.log("First Function");}`)
}, 'first-function');
const taskOne = new sftasks.LambdaInvoke(stack, 'task-one', {
    lambdaFunction: functionOne,
});
const functionTwo = (0, core_1.deployLambdaFunction)(stack, {
    runtime: defaults.COMMERCIAL_REGION_LAMBDA_NODE_RUNTIME,
    handler: 'index.handler',
    code: lambda.Code.fromInline(`exports.handler = async (event) => { console.log("Second Function");}`)
}, 'second-function');
const taskTwo = new sftasks.LambdaInvoke(stack, 'task-two', {
    lambdaFunction: functionTwo,
});
// // Launch the construct
const startState = sfn.DefinitionBody.fromChainable(taskOne.next(taskTwo));
// Setup the pattern props
const props = {
    lambdaFunctionProps: {
        runtime: defaults.COMMERCIAL_REGION_LAMBDA_NODE_RUNTIME,
        handler: 'index.handler',
        code: lambda.Code.fromAsset(`${__dirname}/lambda`)
    },
    stateMachineProps: {
        definitionBody: startState
    },
    logGroupProps: {
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
    }
};
// Add the pattern
new lib_1.LambdaToStepfunctions(stack, 'test-lambda-stepfunctions-construct', props);
// Synth the app
new integ_tests_alpha_1.IntegTest(stack, 'Integ', {
    testCases: [
        stack
    ]
});
//# sourceMappingURL=data:application/json;base64,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