"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenApiGatewayToLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
const openapi_helper_1 = require("./openapi-helper");
class OpenApiGatewayToLambda extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        (0, openapi_helper_1.CheckOpenApiProps)(props);
        // store a counter to be able to uniquely name lambda functions to avoid naming collisions
        let lambdaCounter = 0;
        this.apiLambdaFunctions = props.apiIntegrations.map(apiIntegration => {
            if (apiIntegration.existingLambdaObj && apiIntegration.lambdaFunctionProps) {
                throw new Error(`Error - Cannot provide both lambdaFunctionProps and existingLambdaObj in an ApiIntegrationfor the api integration with id: ${apiIntegration.id}`);
            }
            if (apiIntegration.existingLambdaObj || apiIntegration.lambdaFunctionProps) {
                return {
                    id: apiIntegration.id,
                    lambdaFunction: defaults.buildLambdaFunction(this, {
                        existingLambdaObj: apiIntegration.existingLambdaObj,
                        lambdaFunctionProps: apiIntegration.lambdaFunctionProps
                    }, `${apiIntegration.id}ApiFunction${lambdaCounter++}`)
                };
            }
            else {
                throw new Error(`One of existingLambdaObj or lambdaFunctionProps must be specified for the api integration with id: ${apiIntegration.id}`);
            }
        });
        const definition = (0, openapi_helper_1.ObtainApiDefinition)(this, {
            tokenToFunctionMap: this.apiLambdaFunctions,
            apiDefinitionBucket: props.apiDefinitionBucket,
            apiDefinitionKey: props.apiDefinitionKey,
            apiDefinitionAsset: props.apiDefinitionAsset,
            apiJsonDefinition: props.apiDefinitionJson,
            internalTransformTimeout: props.internalTransformTimeout,
            internalTransformMemorySize: props.internalTransformMemorySize
        });
        const specRestApiResponse = defaults.CreateSpecRestApi(this, {
            ...props.apiGatewayProps,
            apiDefinition: definition
        }, props.logGroupProps);
        this.apiGateway = specRestApiResponse.api;
        this.apiGatewayCloudWatchRole = specRestApiResponse.role;
        this.apiGatewayLogGroup = specRestApiResponse.logGroup;
        // Redeploy the API any time a decoupled (non-inline) API definition changes (from asset or s3 object)
        this.apiGateway.latestDeployment?.addToLogicalId(props.apiDefinitionKey ?? props.apiDefinitionAsset?.s3ObjectKey);
        this.apiLambdaFunctions.forEach(apiLambdaFunction => {
            // Redeploy the API any time one of the lambda functions changes
            this.apiGateway.latestDeployment?.addToLogicalId(apiLambdaFunction.lambdaFunction.functionArn);
            // Grant APIGW invocation rights for each lambda function
            apiLambdaFunction.lambdaFunction.addPermission('PermitAPIGInvocation', {
                principal: new iam.ServicePrincipal('apigateway.amazonaws.com'),
                sourceArn: this.apiGateway.arnForExecuteApi('*')
            });
        });
    }
}
exports.OpenApiGatewayToLambda = OpenApiGatewayToLambda;
_a = JSII_RTTI_SYMBOL_1;
OpenApiGatewayToLambda[_a] = { fqn: "@aws-solutions-constructs/aws-openapigateway-lambda.OpenApiGatewayToLambda", version: "2.69.0" };
//# sourceMappingURL=data:application/json;base64,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