"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenApiGatewayToLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
const openapi_helper_1 = require("./openapi-helper");
class OpenApiGatewayToLambda extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        (0, openapi_helper_1.CheckOpenApiProps)(props);
        // store a counter to be able to uniquely name lambda functions to avoid naming collisions
        let lambdaCounter = 0;
        this.apiLambdaFunctions = props.apiIntegrations.map(apiIntegration => {
            if (apiIntegration.existingLambdaObj && apiIntegration.lambdaFunctionProps) {
                throw new Error(`Error - Cannot provide both lambdaFunctionProps and existingLambdaObj in an ApiIntegrationfor the api integration with id: ${apiIntegration.id}`);
            }
            if (apiIntegration.existingLambdaObj || apiIntegration.lambdaFunctionProps) {
                return {
                    id: apiIntegration.id,
                    lambdaFunction: defaults.buildLambdaFunction(this, {
                        existingLambdaObj: apiIntegration.existingLambdaObj,
                        lambdaFunctionProps: apiIntegration.lambdaFunctionProps
                    }, `${apiIntegration.id}ApiFunction${lambdaCounter++}`)
                };
            }
            else {
                throw new Error(`One of existingLambdaObj or lambdaFunctionProps must be specified for the api integration with id: ${apiIntegration.id}`);
            }
        });
        const definition = (0, openapi_helper_1.ObtainApiDefinition)(this, {
            tokenToFunctionMap: this.apiLambdaFunctions,
            apiDefinitionBucket: props.apiDefinitionBucket,
            apiDefinitionKey: props.apiDefinitionKey,
            apiDefinitionAsset: props.apiDefinitionAsset,
            apiJsonDefinition: props.apiDefinitionJson,
            internalTransformTimeout: props.internalTransformTimeout,
            internalTransformMemorySize: props.internalTransformMemorySize
        });
        const specRestApiResponse = defaults.CreateSpecRestApi(this, {
            ...props.apiGatewayProps,
            apiDefinition: definition
        }, props.logGroupProps);
        this.apiGateway = specRestApiResponse.api;
        this.apiGatewayCloudWatchRole = specRestApiResponse.role;
        this.apiGatewayLogGroup = specRestApiResponse.logGroup;
        // Redeploy the API any time a decoupled (non-inline) API definition changes (from asset or s3 object)
        this.apiGateway.latestDeployment?.addToLogicalId(props.apiDefinitionKey ?? props.apiDefinitionAsset?.s3ObjectKey);
        this.apiLambdaFunctions.forEach(apiLambdaFunction => {
            // Redeploy the API any time one of the lambda functions changes
            this.apiGateway.latestDeployment?.addToLogicalId(apiLambdaFunction.lambdaFunction.functionArn);
            // Grant APIGW invocation rights for each lambda function
            apiLambdaFunction.lambdaFunction.addPermission(`${id}PermitAPIGInvocation`, {
                principal: new iam.ServicePrincipal('apigateway.amazonaws.com'),
                sourceArn: this.apiGateway.arnForExecuteApi('*')
            });
        });
    }
}
exports.OpenApiGatewayToLambda = OpenApiGatewayToLambda;
_a = JSII_RTTI_SYMBOL_1;
OpenApiGatewayToLambda[_a] = { fqn: "@aws-solutions-constructs/aws-openapigateway-lambda.OpenApiGatewayToLambda", version: "2.72.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQWNBLDJDQUF1QztBQUd2QywyQ0FBMkM7QUFFM0MsMkRBQTJEO0FBRzNELHFEQUE2RztBQW1GN0csTUFBYSxzQkFBdUIsU0FBUSxzQkFBUztJQU1uRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQWtDO1FBQzFFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakIsSUFBQSxrQ0FBaUIsRUFBQyxLQUFLLENBQUMsQ0FBQztRQUV6QiwwRkFBMEY7UUFDMUYsSUFBSSxhQUFhLEdBQUcsQ0FBQyxDQUFDO1FBRXRCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsRUFBRTtZQUNuRSxJQUFJLGNBQWMsQ0FBQyxpQkFBaUIsSUFBSSxjQUFjLENBQUMsbUJBQW1CLEVBQUUsQ0FBQztnQkFDM0UsTUFBTSxJQUFJLEtBQUssQ0FBQyw4SEFBOEgsY0FBYyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7WUFDckssQ0FBQztZQUNELElBQUksY0FBYyxDQUFDLGlCQUFpQixJQUFJLGNBQWMsQ0FBQyxtQkFBbUIsRUFBRSxDQUFDO2dCQUMzRSxPQUFPO29CQUNMLEVBQUUsRUFBRSxjQUFjLENBQUMsRUFBRTtvQkFDckIsY0FBYyxFQUFFLFFBQVEsQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLEVBQUU7d0JBQ2pELGlCQUFpQixFQUFFLGNBQWMsQ0FBQyxpQkFBaUI7d0JBQ25ELG1CQUFtQixFQUFFLGNBQWMsQ0FBQyxtQkFBbUI7cUJBQ3hELEVBQUUsR0FBRyxjQUFjLENBQUMsRUFBRSxjQUFjLGFBQWEsRUFBRSxFQUFFLENBQUM7aUJBQ3hELENBQUM7WUFDSixDQUFDO2lCQUFNLENBQUM7Z0JBQ04sTUFBTSxJQUFJLEtBQUssQ0FBQyxzR0FBc0csY0FBYyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7WUFDN0ksQ0FBQztRQUNILENBQUMsQ0FBQyxDQUFDO1FBRUgsTUFBTSxVQUFVLEdBQUcsSUFBQSxvQ0FBbUIsRUFBQyxJQUFJLEVBQUc7WUFDNUMsa0JBQWtCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtZQUMzQyxtQkFBbUIsRUFBRSxLQUFLLENBQUMsbUJBQW1CO1lBQzlDLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxnQkFBZ0I7WUFDeEMsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQjtZQUM1QyxpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCO1lBQzFDLHdCQUF3QixFQUFFLEtBQUssQ0FBQyx3QkFBd0I7WUFDeEQsMkJBQTJCLEVBQUUsS0FBSyxDQUFDLDJCQUEyQjtTQUMvRCxDQUFDLENBQUM7UUFFSCxNQUFNLG1CQUFtQixHQUFHLFFBQVEsQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLEVBQUU7WUFDM0QsR0FBRyxLQUFLLENBQUMsZUFBZTtZQUN4QixhQUFhLEVBQUUsVUFBVTtTQUMxQixFQUFFLEtBQUssQ0FBQyxhQUFhLENBQUMsQ0FBQztRQUV4QixJQUFJLENBQUMsVUFBVSxHQUFHLG1CQUFtQixDQUFDLEdBQUcsQ0FBQztRQUMxQyxJQUFJLENBQUMsd0JBQXdCLEdBQUcsbUJBQW1CLENBQUMsSUFBSSxDQUFDO1FBQ3pELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxtQkFBbUIsQ0FBQyxRQUFRLENBQUM7UUFFdkQsc0dBQXNHO1FBQ3RHLElBQUksQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLEVBQUUsY0FBYyxDQUFDLEtBQUssQ0FBQyxnQkFBZ0IsSUFBSSxLQUFLLENBQUMsa0JBQWtCLEVBQUUsV0FBVyxDQUFDLENBQUM7UUFDbEgsSUFBSSxDQUFDLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxFQUFFO1lBQ2xELGdFQUFnRTtZQUNoRSxJQUFJLENBQUMsVUFBVSxDQUFDLGdCQUFnQixFQUFFLGNBQWMsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLENBQUMsV0FBVyxDQUFDLENBQUM7WUFDL0YseURBQXlEO1lBQ3pELGlCQUFpQixDQUFDLGNBQWMsQ0FBQyxhQUFhLENBQUMsR0FBRyxFQUFFLHNCQUFzQixFQUFFO2dCQUMxRSxTQUFTLEVBQUUsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsMEJBQTBCLENBQUM7Z0JBQy9ELFNBQVMsRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsQ0FBQzthQUNqRCxDQUFDLENBQUM7UUFDTCxDQUFDLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBNURILHdEQTZEQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiAgd2l0aCB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqICBvciBpbiB0aGUgJ2xpY2Vuc2UnIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICdBUyBJUycgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFU1xuICogIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiAgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbmltcG9ydCAqIGFzIGNkayBmcm9tIFwiYXdzLWNkay1saWJcIjtcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgYXBpZ2F0ZXdheSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtYXBpZ2F0ZXdheSc7XG5pbXBvcnQgKiBhcyBsb2dzIGZyb20gJ2F3cy1jZGstbGliL2F3cy1sb2dzJztcbmltcG9ydCAqIGFzIGlhbSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCAqIGFzIHMzIGZyb20gJ2F3cy1jZGstbGliL2F3cy1zMyc7XG5pbXBvcnQgKiBhcyBkZWZhdWx0cyBmcm9tICdAYXdzLXNvbHV0aW9ucy1jb25zdHJ1Y3RzL2NvcmUnO1xuaW1wb3J0IHsgUmVzdEFwaUJhc2VQcm9wcyB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1hcGlnYXRld2F5JztcbmltcG9ydCB7IEFzc2V0IH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLXMzLWFzc2V0cyc7XG5pbXBvcnQgeyBBcGlJbnRlZ3JhdGlvbiwgQ2hlY2tPcGVuQXBpUHJvcHMsIEFwaUxhbWJkYUZ1bmN0aW9uLCBPYnRhaW5BcGlEZWZpbml0aW9uIH0gZnJvbSAnLi9vcGVuYXBpLWhlbHBlcic7XG4vLyBvcGVuYXBpLWhlbHBlciBpcyBvbiBpdHMgd2F5IHRvIGNvcmUsIHNvIHRoZXNlIGludGVyZmFjZXMgbXVzdCBiZSBleHBvcnRlZCBoZXJlXG5leHBvcnQgeyBBcGlJbnRlZ3JhdGlvbiwgQXBpTGFtYmRhRnVuY3Rpb24gfSBmcm9tICcuL29wZW5hcGktaGVscGVyJztcblxuZXhwb3J0IGludGVyZmFjZSBPcGVuQXBpR2F0ZXdheVRvTGFtYmRhUHJvcHMge1xuICAvKipcbiAgICogUzMgQnVja2V0IHdoZXJlIHRoZSBPcGVuQVBJIHNwZWMgZmlsZSBpcyBsb2NhdGVkLiBXaGVuIHNwZWNpZnlpbmcgdGhpcyBwcm9wZXJ0eSwgYXBpRGVmaW5pdGlvbktleSBtdXN0IGFsc28gYmUgc3BlY2lmaWVkLlxuICAgKi9cbiAgcmVhZG9ubHkgYXBpRGVmaW5pdGlvbkJ1Y2tldD86IHMzLklCdWNrZXQ7XG4gIC8qKlxuICAgKiBTMyBPYmplY3QgbmFtZSBvZiB0aGUgT3BlbkFQSSBzcGVjIGZpbGUuIFdoZW4gc3BlY2lmeWluZyB0aGlzIHByb3BlcnR5LCBhcGlEZWZpbml0aW9uQnVja2V0IG11c3QgYWxzbyBiZSBzcGVjaWZpZWQuXG4gICAqL1xuICByZWFkb25seSBhcGlEZWZpbml0aW9uS2V5Pzogc3RyaW5nO1xuICAvKipcbiAgICogTG9jYWwgZmlsZSBhc3NldCBvZiB0aGUgT3BlbkFQSSBzcGVjIGZpbGUuXG4gICAqL1xuICByZWFkb25seSBhcGlEZWZpbml0aW9uQXNzZXQ/OiBBc3NldDtcbiAgLyoqXG4gICAqIE9wZW5BUEkgc3BlY2lmaWNhdGlvbiByZXByZXNlbnRlZCBpbiBhIEpTT04gb2JqZWN0IHRvIGJlIGVtYmVkZGVkIGluIHRoZSBDbG91ZEZvcm1hdGlvbiB0ZW1wbGF0ZS5cbiAgICogSU1QT1JUQU5UIC0gSW5jbHVkaW5nIHRoZSBzcGVjIGluIHRoZSB0ZW1wbGF0ZSBpbnRyb2R1Y2VzIGEgcmlzayBvZiB0aGUgdGVtcGxhdGUgZ3Jvd2luZyB0b28gYmlnLCBidXRcbiAgICogdGhlcmUgYXJlIHNvbWUgdXNlIGNhc2VzIHRoYXQgcmVxdWlyZSBhbiBlbWJlZGRlZCBzcGVjLiBVbmxlc3MgeW91ciB1c2UgY2FzZSBleHBsaWNpdGx5IHJlcXVpcmVzIGFuIGVtYmVkZGVkIHNwZWNcbiAgICogeW91IHNob3VsZCBwYXNzIHlvdXIgc3BlYyBhcyBhbiBTMyBhc3NldC5cbiAgICovXG4gIHJlYWRvbmx5IGFwaURlZmluaXRpb25Kc29uPzogYW55O1xuICAvKipcbiAgICogT25lIG9yIG1vcmUga2V5LXZhbHVlIHBhaXJzIHRoYXQgY29udGFpbiBhbiBpZCBmb3IgdGhlIGFwaSBpbnRlZ3JhdGlvblxuICAgKiBhbmQgZWl0aGVyIGFuIGV4aXN0aW5nIGxhbWJkYSBmdW5jdGlvbiBvciBhbiBpbnN0YW5jZSBvZiB0aGUgTGFtYmRhUHJvcHMuXG4gICAqXG4gICAqIEV4YW1wbGU6XG4gICAqIGNvbnN0IGFwaUludGVncmF0aW9uczogQXBpSW50ZWdyYXRpb25bXSA9IFtcbiAgICogICB7XG4gICAqICAgICBpZDogJ01lc3NhZ2VzSGFuZGxlcicsXG4gICAqICAgICBsYW1iZGFGdW5jdGlvblByb3BzOiB7XG4gICAqICAgICAgIHJ1bnRpbWU6IGRlZmF1bHRzLkNPTU1FUkNJQUxfUkVHSU9OX0xBTUJEQV9OT0RFX1JVTlRJTUUsXG4gICAqICAgICAgIGhhbmRsZXI6ICdpbmRleC5oYW5kbGVyJyxcbiAgICogICAgICAgY29kZTogbGFtYmRhLkNvZGUuZnJvbUFzc2V0KGAke19fZGlybmFtZX0vbWVzc2FnZXMtbGFtYmRhYCksXG4gICAqICAgICB9XG4gICAqICAgfSxcbiAgICogICB7XG4gICAqICAgICBpZDogJ1Bob3Rvc0hhbmRsZXInLFxuICAgKiAgICAgZXhpc3RpbmdMYW1iZGFPYmo6IG5ldyBsYW1iZGEuRnVuY3Rpb24odGhpcywgJ1Bob3Rvc0xhbWJkYScsIHtcbiAgICogICAgICAgcnVudGltZTogZGVmYXVsdHMuQ09NTUVSQ0lBTF9SRUdJT05fTEFNQkRBX05PREVfUlVOVElNRSxcbiAgICogICAgICAgaGFuZGxlcjogJ2luZGV4LmhhbmRsZXInLFxuICAgKiAgICAgICBjb2RlOiBsYW1iZGEuQ29kZS5mcm9tQXNzZXQoYCR7X19kaXJuYW1lfS9waG90b3MtbGFtYmRhYCksXG4gICAqICAgICB9KVxuICAgKiAgIH1cbiAgICogXVxuICAgKi9cbiAgcmVhZG9ubHkgYXBpSW50ZWdyYXRpb25zOiBBcGlJbnRlZ3JhdGlvbltdO1xuICAvKipcbiAgICogT3B0aW9uYWwgdXNlci1wcm92aWRlZCBwcm9wcyB0byBvdmVycmlkZSB0aGUgZGVmYXVsdCBwcm9wcyBmb3IgdGhlIEFQSS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBEZWZhdWx0IHByb3BzIGFyZSB1c2VkLlxuICAgKi9cbiAgcmVhZG9ubHkgYXBpR2F0ZXdheVByb3BzPzogUmVzdEFwaUJhc2VQcm9wcztcbiAgLyoqXG4gICAqIFVzZXIgcHJvdmlkZWQgcHJvcHMgdG8gb3ZlcnJpZGUgdGhlIGRlZmF1bHQgcHJvcHMgZm9yIHRoZSBDbG91ZFdhdGNoTG9ncyBMb2dHcm91cC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBEZWZhdWx0IHByb3BzIGFyZSB1c2VkXG4gICAqL1xuICByZWFkb25seSBsb2dHcm91cFByb3BzPzogbG9ncy5Mb2dHcm91cFByb3BzXG4gIC8qKlxuICAgKiBPcHRpb25hbCB1c2VyLWRlZmluZWQgdGltZW91dCBmb3IgdGhlIExhbWJkYSBmdW5jdGlvbiBjdXN0b20gcmVzb3VyY2UgaW5zdGFsbGVkIHRvIGRvIHRoZSBPcGVuQVBJIGRlZmluaXRpb24gdHJhbnNmb3JtYXRpb24uXG4gICAqXG4gICAqIFRoaXMgc2V0dGluZyBkb2VzIG5vdCBhZmZlY3QgdGhlIGRlcGxveWVkIGFyY2hpdGVjdHVyZSAtIG9ubHkgdGhlIGFiaWxpdHkgZm9yIHRoZSBDb25zdHJ1Y3QgdG8gY29tcGxldGUgaXRzIHdvcmsuXG4gICAqXG4gICAqIERlZmF1bHRzIHRvIDEgbWludXRlLCBidXQgZm9yIGxhcmdlciBmaWxlcyAoaHVuZHJlZHMgb2YgbWVnYWJ5dGVzIG9yIGdpZ2FieXRlcyBpbiBzaXplKSB0aGlzIHZhbHVlIG1heSBuZWVkIHRvIGJlIGluY3JlYXNlZC5cbiAgICpcbiAgICogQGRlZmF1bHQgRHVyYXRpb24ubWludXRlcygxKVxuICAgKi9cbiAgcmVhZG9ubHkgaW50ZXJuYWxUcmFuc2Zvcm1UaW1lb3V0PzogY2RrLkR1cmF0aW9uO1xuICAvKipcbiAgICogT3B0aW9uYWwgdXNlci1kZWZpbmVkIG1lbW9yeSBzaXplIGZvciB0aGUgTGFtYmRhIGZ1bmN0aW9uIGN1c3RvbSByZXNvdXJjZSBpbnN0YWxsZWQgdG8gZG8gdGhlIE9wZW5BUEkgZGVmaW5pdGlvbiB0cmFuc2Zvcm1hdGlvbi5cbiAgICpcbiAgICogVGhpcyBzZXR0aW5nIGRvZXMgbm90IGFmZmVjdCB0aGUgZGVwbG95ZWQgYXJjaGl0ZWN0dXJlIC0gb25seSB0aGUgYWJpbGl0eSBmb3IgdGhlIENvbnN0cnVjdCB0byBjb21wbGV0ZSBpdHMgd29yay5cbiAgICpcbiAgICogRGVmYXVsdHMgdG8gMTAyNCBNaUIsIGJ1dCBmb3IgbGFyZ2VyIGZpbGVzIChodW5kcmVkcyBvZiBtZWdhYnl0ZXMgb3IgZ2lnYWJ5dGVzIGluIHNpemUpIHRoaXMgdmFsdWUgbWF5IG5lZWQgdG8gYmUgaW5jcmVhc2VkLlxuICAgKlxuICAgKiBAZGVmYXVsdCAxMDI0XG4gICAqL1xuICByZWFkb25seSBpbnRlcm5hbFRyYW5zZm9ybU1lbW9yeVNpemU/OiBudW1iZXI7XG59XG5cbmV4cG9ydCBjbGFzcyBPcGVuQXBpR2F0ZXdheVRvTGFtYmRhIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IGFwaUdhdGV3YXk6IGFwaWdhdGV3YXkuU3BlY1Jlc3RBcGk7XG4gIHB1YmxpYyByZWFkb25seSBhcGlHYXRld2F5Q2xvdWRXYXRjaFJvbGU/OiBpYW0uUm9sZTtcbiAgcHVibGljIHJlYWRvbmx5IGFwaUdhdGV3YXlMb2dHcm91cDogbG9ncy5Mb2dHcm91cDtcbiAgcHVibGljIHJlYWRvbmx5IGFwaUxhbWJkYUZ1bmN0aW9uczogQXBpTGFtYmRhRnVuY3Rpb25bXTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogT3BlbkFwaUdhdGV3YXlUb0xhbWJkYVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICBDaGVja09wZW5BcGlQcm9wcyhwcm9wcyk7XG5cbiAgICAvLyBzdG9yZSBhIGNvdW50ZXIgdG8gYmUgYWJsZSB0byB1bmlxdWVseSBuYW1lIGxhbWJkYSBmdW5jdGlvbnMgdG8gYXZvaWQgbmFtaW5nIGNvbGxpc2lvbnNcbiAgICBsZXQgbGFtYmRhQ291bnRlciA9IDA7XG5cbiAgICB0aGlzLmFwaUxhbWJkYUZ1bmN0aW9ucyA9IHByb3BzLmFwaUludGVncmF0aW9ucy5tYXAoYXBpSW50ZWdyYXRpb24gPT4ge1xuICAgICAgaWYgKGFwaUludGVncmF0aW9uLmV4aXN0aW5nTGFtYmRhT2JqICYmIGFwaUludGVncmF0aW9uLmxhbWJkYUZ1bmN0aW9uUHJvcHMpIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKGBFcnJvciAtIENhbm5vdCBwcm92aWRlIGJvdGggbGFtYmRhRnVuY3Rpb25Qcm9wcyBhbmQgZXhpc3RpbmdMYW1iZGFPYmogaW4gYW4gQXBpSW50ZWdyYXRpb25mb3IgdGhlIGFwaSBpbnRlZ3JhdGlvbiB3aXRoIGlkOiAke2FwaUludGVncmF0aW9uLmlkfWApO1xuICAgICAgfVxuICAgICAgaWYgKGFwaUludGVncmF0aW9uLmV4aXN0aW5nTGFtYmRhT2JqIHx8IGFwaUludGVncmF0aW9uLmxhbWJkYUZ1bmN0aW9uUHJvcHMpIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICBpZDogYXBpSW50ZWdyYXRpb24uaWQsXG4gICAgICAgICAgbGFtYmRhRnVuY3Rpb246IGRlZmF1bHRzLmJ1aWxkTGFtYmRhRnVuY3Rpb24odGhpcywge1xuICAgICAgICAgICAgZXhpc3RpbmdMYW1iZGFPYmo6IGFwaUludGVncmF0aW9uLmV4aXN0aW5nTGFtYmRhT2JqLFxuICAgICAgICAgICAgbGFtYmRhRnVuY3Rpb25Qcm9wczogYXBpSW50ZWdyYXRpb24ubGFtYmRhRnVuY3Rpb25Qcm9wc1xuICAgICAgICAgIH0sIGAke2FwaUludGVncmF0aW9uLmlkfUFwaUZ1bmN0aW9uJHtsYW1iZGFDb3VudGVyKyt9YClcbiAgICAgICAgfTtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcihgT25lIG9mIGV4aXN0aW5nTGFtYmRhT2JqIG9yIGxhbWJkYUZ1bmN0aW9uUHJvcHMgbXVzdCBiZSBzcGVjaWZpZWQgZm9yIHRoZSBhcGkgaW50ZWdyYXRpb24gd2l0aCBpZDogJHthcGlJbnRlZ3JhdGlvbi5pZH1gKTtcbiAgICAgIH1cbiAgICB9KTtcblxuICAgIGNvbnN0IGRlZmluaXRpb24gPSBPYnRhaW5BcGlEZWZpbml0aW9uKHRoaXMsICB7XG4gICAgICB0b2tlblRvRnVuY3Rpb25NYXA6IHRoaXMuYXBpTGFtYmRhRnVuY3Rpb25zLFxuICAgICAgYXBpRGVmaW5pdGlvbkJ1Y2tldDogcHJvcHMuYXBpRGVmaW5pdGlvbkJ1Y2tldCxcbiAgICAgIGFwaURlZmluaXRpb25LZXk6IHByb3BzLmFwaURlZmluaXRpb25LZXksXG4gICAgICBhcGlEZWZpbml0aW9uQXNzZXQ6IHByb3BzLmFwaURlZmluaXRpb25Bc3NldCxcbiAgICAgIGFwaUpzb25EZWZpbml0aW9uOiBwcm9wcy5hcGlEZWZpbml0aW9uSnNvbixcbiAgICAgIGludGVybmFsVHJhbnNmb3JtVGltZW91dDogcHJvcHMuaW50ZXJuYWxUcmFuc2Zvcm1UaW1lb3V0LFxuICAgICAgaW50ZXJuYWxUcmFuc2Zvcm1NZW1vcnlTaXplOiBwcm9wcy5pbnRlcm5hbFRyYW5zZm9ybU1lbW9yeVNpemVcbiAgICB9KTtcblxuICAgIGNvbnN0IHNwZWNSZXN0QXBpUmVzcG9uc2UgPSBkZWZhdWx0cy5DcmVhdGVTcGVjUmVzdEFwaSh0aGlzLCB7XG4gICAgICAuLi5wcm9wcy5hcGlHYXRld2F5UHJvcHMsXG4gICAgICBhcGlEZWZpbml0aW9uOiBkZWZpbml0aW9uXG4gICAgfSwgcHJvcHMubG9nR3JvdXBQcm9wcyk7XG5cbiAgICB0aGlzLmFwaUdhdGV3YXkgPSBzcGVjUmVzdEFwaVJlc3BvbnNlLmFwaTtcbiAgICB0aGlzLmFwaUdhdGV3YXlDbG91ZFdhdGNoUm9sZSA9IHNwZWNSZXN0QXBpUmVzcG9uc2Uucm9sZTtcbiAgICB0aGlzLmFwaUdhdGV3YXlMb2dHcm91cCA9IHNwZWNSZXN0QXBpUmVzcG9uc2UubG9nR3JvdXA7XG5cbiAgICAvLyBSZWRlcGxveSB0aGUgQVBJIGFueSB0aW1lIGEgZGVjb3VwbGVkIChub24taW5saW5lKSBBUEkgZGVmaW5pdGlvbiBjaGFuZ2VzIChmcm9tIGFzc2V0IG9yIHMzIG9iamVjdClcbiAgICB0aGlzLmFwaUdhdGV3YXkubGF0ZXN0RGVwbG95bWVudD8uYWRkVG9Mb2dpY2FsSWQocHJvcHMuYXBpRGVmaW5pdGlvbktleSA/PyBwcm9wcy5hcGlEZWZpbml0aW9uQXNzZXQ/LnMzT2JqZWN0S2V5KTtcbiAgICB0aGlzLmFwaUxhbWJkYUZ1bmN0aW9ucy5mb3JFYWNoKGFwaUxhbWJkYUZ1bmN0aW9uID0+IHtcbiAgICAgIC8vIFJlZGVwbG95IHRoZSBBUEkgYW55IHRpbWUgb25lIG9mIHRoZSBsYW1iZGEgZnVuY3Rpb25zIGNoYW5nZXNcbiAgICAgIHRoaXMuYXBpR2F0ZXdheS5sYXRlc3REZXBsb3ltZW50Py5hZGRUb0xvZ2ljYWxJZChhcGlMYW1iZGFGdW5jdGlvbi5sYW1iZGFGdW5jdGlvbi5mdW5jdGlvbkFybik7XG4gICAgICAvLyBHcmFudCBBUElHVyBpbnZvY2F0aW9uIHJpZ2h0cyBmb3IgZWFjaCBsYW1iZGEgZnVuY3Rpb25cbiAgICAgIGFwaUxhbWJkYUZ1bmN0aW9uLmxhbWJkYUZ1bmN0aW9uLmFkZFBlcm1pc3Npb24oYCR7aWR9UGVybWl0QVBJR0ludm9jYXRpb25gLCB7XG4gICAgICAgIHByaW5jaXBhbDogbmV3IGlhbS5TZXJ2aWNlUHJpbmNpcGFsKCdhcGlnYXRld2F5LmFtYXpvbmF3cy5jb20nKSxcbiAgICAgICAgc291cmNlQXJuOiB0aGlzLmFwaUdhdGV3YXkuYXJuRm9yRXhlY3V0ZUFwaSgnKicpXG4gICAgICB9KTtcbiAgICB9KTtcbiAgfVxufVxuIl19