"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenApiGatewayToLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
const openapi_helper_1 = require("./openapi-helper");
class OpenApiGatewayToLambda extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        (0, openapi_helper_1.CheckOpenApiProps)(props);
        this.apiLambdaFunctions = (0, openapi_helper_1.MapApiIntegrationsToApiFunction)(this, props.apiIntegrations);
        const definition = (0, openapi_helper_1.ObtainApiDefinition)(this, {
            tokenToFunctionMap: this.apiLambdaFunctions,
            apiDefinitionBucket: props.apiDefinitionBucket,
            apiDefinitionKey: props.apiDefinitionKey,
            apiDefinitionAsset: props.apiDefinitionAsset,
            apiJsonDefinition: props.apiDefinitionJson,
            internalTransformTimeout: props.internalTransformTimeout,
            internalTransformMemorySize: props.internalTransformMemorySize
        });
        const specRestApiResponse = defaults.CreateSpecRestApi(this, {
            ...props.apiGatewayProps,
            apiDefinition: definition
        }, props.logGroupProps);
        this.apiGateway = specRestApiResponse.api;
        this.apiGatewayCloudWatchRole = specRestApiResponse.role;
        this.apiGatewayLogGroup = specRestApiResponse.logGroup;
        // Redeploy the API any time a decoupled (non-inline) API definition changes (from asset or s3 object)
        this.apiGateway.latestDeployment?.addToLogicalId(props.apiDefinitionKey ?? props.apiDefinitionAsset?.s3ObjectKey);
        this.apiLambdaFunctions.forEach(apiLambdaFunction => {
            const targetInterface = (0, openapi_helper_1.ExtractFunctionInterface)(apiLambdaFunction);
            // Redeploy the API any time one of the lambda functions changes
            this.apiGateway.latestDeployment?.addToLogicalId(targetInterface.functionArn);
            targetInterface.addPermission(`${id}PermitAPIGInvocation`, {
                principal: new iam.ServicePrincipal('apigateway.amazonaws.com'),
                sourceArn: `arn:${cdk.Aws.PARTITION}:execute-api:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:${this.apiGateway.restApiId}/*/*`
            });
        });
    }
}
exports.OpenApiGatewayToLambda = OpenApiGatewayToLambda;
_a = JSII_RTTI_SYMBOL_1;
OpenApiGatewayToLambda[_a] = { fqn: "@aws-solutions-constructs/aws-openapigateway-lambda.OpenApiGatewayToLambda", version: "2.90.3" };
//# sourceMappingURL=data:application/json;base64,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