#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = ['boto3', 'ozone']

setup_requirements = ['pytest-runner', ]

test_requirements = ['pytest', ]

setup(
    author="John Mille",
    author_email='john@lambda-my-aws.io',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: Apache Software License',
        'Natural Language :: English',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
    ],
    description="Py Lib to handle calls to Lambda based on the caller and formats answers accordingly",
    install_requires=requirements,
    license="Apache Software License 2.0",
    long_description=readme,
    include_package_data=True,
    keywords='awslambda_handler',
    name='awslambda_handler',
    packages=find_packages(include=['awslambda_handler*']),
    setup_requires=setup_requirements,
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/johnpreston/awslambda_handler',
    version='0.1.4',
    zip_safe=False,
)
