from .utils import (
    TransferProgress,
    slugify_string,
)
from .server import (
    ServerAPIBase,
)

from .server_api import (
    ServerAPI,
    ServiceContext,

    init_service,

    is_connection_created,
    close_connection,
    change_token,
    set_environments,
    get_server_api_connection,

    get_base_url,
    get_rest_url,

    raw_get,
    raw_post,
    raw_put,
    raw_patch,
    raw_delete,

    get,
    post,
    put,
    patch,
    delete,

    get_event,
    get_events,
    dispatch_event,
    update_event,
    enroll_event_job,

    download_file,
    upload_file,

    query_graphql,

    get_addons_info,
    download_addon_private_file,

    get_dependencies_info,
    update_dependency_info,

    download_dependency_package,
    upload_dependency_package,
    delete_dependency_package,

    get_full_production_settings,
    get_production_settings,
    get_full_project_settings,
    get_project_settings,
    get_addon_settings,

    get_user,
    get_users,

    get_attributes_for_type,
    get_default_fields_for_type,

    get_project_anatomy_preset,
    get_project_anatomy_presets,

    get_projects,
    get_project,
    create_project,
    delete_project,

    get_folder_by_id,
    get_folder_by_name,
    get_folder_by_path,
    get_folders,

    get_tasks,

    get_folder_ids_with_subsets,
    get_subset_by_id,
    get_subset_by_name,
    get_subsets,
    get_subset_families,

    get_version_by_id,
    get_version_by_name,
    version_is_latest,
    get_versions,
    get_hero_version_by_subset_id,
    get_hero_version_by_id,
    get_hero_versions,
    get_last_versions,
    get_last_version_by_subset_id,
    get_last_version_by_subset_name,
    get_representation_by_id,
    get_representation_by_name,
    get_representations,
    get_representations_parents,
    get_representation_parents,

    create_thumbnail,
    get_thumbnail,
    get_folder_thumbnail,
    get_version_thumbnail,
    get_workfile_thumbnail,
)


__all__ = (
    "TransferProgress",
    "slugify_string",

    "ServerAPIBase",

    "ServerAPI",
    "ServiceContext",
    "init_service",

    "is_connection_created",
    "close_connection",
    "change_token",
    "set_environments",
    "get_server_api_connection",

    "get_base_url",
    "get_rest_url",

    "raw_get",
    "raw_post",
    "raw_put",
    "raw_patch",
    "raw_delete",

    "get",
    "post",
    "put",
    "patch",
    "delete",

    "get_event",
    "get_events",
    "dispatch_event",
    "update_event",
    "enroll_event_job",

    "download_file",
    "upload_file",

    "query_graphql",

    "get_addons_info",
    "download_addon_private_file",

    "get_dependencies_info",
    "update_dependency_info",

    "download_dependency_package",
    "upload_dependency_package",
    "delete_dependency_package",

    "get_full_production_settings",
    "get_production_settings",
    "get_full_project_settings",
    "get_project_settings",
    "get_addon_settings",

    "get_user",
    "get_users",

    "get_attributes_for_type",
    "get_default_fields_for_type",

    "get_project_anatomy_preset",
    "get_project_anatomy_presets",

    "get_projects",
    "get_project",
    "create_project",
    "delete_project",

    "get_folder_by_id",
    "get_folder_by_name",
    "get_folder_by_path",
    "get_folders",

    "get_tasks",

    "get_folder_ids_with_subsets",
    "get_subset_by_id",
    "get_subset_by_name",
    "get_subsets",
    "get_subset_families",

    "get_version_by_id",
    "get_version_by_name",
    "version_is_latest",
    "get_versions",
    "get_hero_version_by_subset_id",
    "get_hero_version_by_id",
    "get_hero_versions",
    "get_last_versions",
    "get_last_version_by_subset_id",
    "get_last_version_by_subset_name",
    "get_representation_by_id",
    "get_representation_by_name",
    "get_representations",
    "get_representations_parents",
    "get_representation_parents",

    "create_thumbnail",
    "get_thumbnail",
    "get_folder_thumbnail",
    "get_version_thumbnail",
    "get_workfile_thumbnail",
)
