from .version import __version__
from .utils import (
    TransferProgress,
    slugify_string,
    create_dependency_package_basename,
)
from .server_api import (
    ServerAPI,
)

from ._api import (
    GlobalServerAPI,
    ServiceContext,

    init_service,
    get_service_name,
    get_service_addon_name,
    get_service_addon_version,
    get_service_addon_settings,

    is_connection_created,
    create_connection,
    close_connection,
    change_token,
    set_environments,
    get_server_api_connection,
    get_site_id,
    set_site_id,
    get_client_version,
    set_client_version,
    get_default_settings_variant,
    set_default_settings_variant,
    get_sender,
    set_sender,

    get_base_url,
    get_rest_url,

    raw_get,
    raw_post,
    raw_put,
    raw_patch,
    raw_delete,

    get,
    post,
    put,
    patch,
    delete,

    get_event,
    get_events,
    dispatch_event,
    update_event,
    enroll_event_job,

    download_file,
    upload_file,

    query_graphql,

    get_addons_info,
    get_addon_url,
    download_addon_private_file,

    get_installers,
    create_installer,
    update_installer,
    delete_installer,
    download_installer,
    upload_installer,

    get_dependencies_info,
    update_dependency_info,
    get_dependency_packages,
    create_dependency_package,
    update_dependency_package,
    delete_dependency_package,

    download_dependency_package,
    upload_dependency_package,

    upload_addon_zip,

    get_bundles,
    create_bundle,
    update_bundle,
    delete_bundle,

    get_info,
    get_server_version,
    get_server_version_tuple,
    get_user,
    get_users,

    get_attributes_for_type,
    get_attributes_fields_for_type,
    get_default_fields_for_type,

    get_project_anatomy_preset,
    get_project_anatomy_presets,
    get_project_roots_by_site,
    get_project_roots_for_site,

    get_addon_site_settings_schema,
    get_addon_settings_schema,

    get_addon_studio_settings,
    get_addon_project_settings,
    get_addon_settings,
    get_bundle_settings,
    get_addons_studio_settings,
    get_addons_project_settings,
    get_addons_settings,

    get_secrets,
    get_secret,
    save_secret,
    delete_secret,

    get_project_names,
    get_projects,
    get_project,
    create_project,
    update_project,
    delete_project,

    get_folder_by_id,
    get_folder_by_name,
    get_folder_by_path,
    get_folders,
    get_folders_hierarchy,

    get_tasks,
    get_task_by_id,
    get_task_by_name,

    get_folder_ids_with_products,
    get_product_by_id,
    get_product_by_name,
    get_products,
    get_product_types,
    get_project_product_types,
    get_product_type_names,

    get_version_by_id,
    get_version_by_name,
    version_is_latest,
    get_versions,
    get_hero_version_by_product_id,
    get_hero_version_by_id,
    get_hero_versions,
    get_last_versions,
    get_last_version_by_product_id,
    get_last_version_by_product_name,
    get_representation_by_id,
    get_representation_by_name,
    get_representations,
    get_representations_parents,
    get_representation_parents,
    get_repre_ids_by_context_filters,

    get_workfiles_info,
    get_workfile_info,
    get_workfile_info_by_id,

    get_thumbnail_by_id,
    get_thumbnail,
    get_folder_thumbnail,
    get_version_thumbnail,
    get_workfile_thumbnail,
    create_thumbnail,
    update_thumbnail,

    get_full_link_type_name,
    get_link_types,
    get_link_type,
    create_link_type,
    delete_link_type,
    make_sure_link_type_exists,

    create_link,
    delete_link,
    get_entities_links,
    get_folder_links,
    get_folders_links,
    get_task_links,
    get_tasks_links,
    get_product_links,
    get_products_links,
    get_version_links,
    get_versions_links,
    get_representations_links,
    get_representation_links,

    send_batch_operations,
)


__all__ = (
    "__version__",

    "TransferProgress",
    "slugify_string",
    "create_dependency_package_basename",

    "ServerAPI",

    "GlobalServerAPI",
    "ServiceContext",

    "init_service",
    "get_service_name",
    "get_service_addon_name",
    "get_service_addon_version",
    "get_service_addon_settings",

    "is_connection_created",
    "create_connection",
    "close_connection",
    "change_token",
    "set_environments",
    "get_server_api_connection",
    "get_site_id",
    "set_site_id",
    "get_client_version",
    "set_client_version",
    "get_default_settings_variant",
    "set_default_settings_variant",
    "get_sender",
    "set_sender",

    "get_base_url",
    "get_rest_url",

    "raw_get",
    "raw_post",
    "raw_put",
    "raw_patch",
    "raw_delete",

    "get",
    "post",
    "put",
    "patch",
    "delete",

    "get_event",
    "get_events",
    "dispatch_event",
    "update_event",
    "enroll_event_job",

    "download_file",
    "upload_file",

    "query_graphql",

    "get_addons_info",
    "get_addon_url",
    "download_addon_private_file",

    "get_installers",
    "create_installer",
    "update_installer",
    "delete_installer",
    "download_installer",
    "upload_installer",

    "get_dependencies_info",
    "update_dependency_info",
    "get_dependency_packages",
    "create_dependency_package",
    "update_dependency_package",
    "delete_dependency_package",

    "download_dependency_package",
    "upload_dependency_package",

    "upload_addon_zip",

    "get_bundles",
    "create_bundle",
    "update_bundle",
    "delete_bundle",

    "get_info",
    "get_server_version",
    "get_server_version_tuple",
    "get_user",
    "get_users",

    "get_attributes_for_type",
    "get_attributes_fields_for_type",
    "get_default_fields_for_type",

    "get_project_anatomy_preset",
    "get_project_anatomy_presets",
    "get_project_roots_by_site",
    "get_project_roots_for_site",

    "get_addon_site_settings_schema",
    "get_addon_settings_schema",
    "get_addon_studio_settings",
    "get_addon_project_settings",
    "get_addon_settings",
    "get_bundle_settings",
    "get_addons_studio_settings",
    "get_addons_project_settings",
    "get_addons_settings",

    "get_secrets",
    "get_secret",
    "save_secret",
    "delete_secret",

    "get_project_names",
    "get_projects",
    "get_project",
    "create_project",
    "update_project",
    "delete_project",

    "get_folder_by_id",
    "get_folder_by_name",
    "get_folder_by_path",
    "get_folders",

    "get_tasks",
    "get_task_by_id",
    "get_task_by_name",

    "get_folder_ids_with_products",
    "get_product_by_id",
    "get_product_by_name",
    "get_products",
    "get_product_types",
    "get_project_product_types",
    "get_product_type_names",

    "get_version_by_id",
    "get_version_by_name",
    "version_is_latest",
    "get_versions",
    "get_hero_version_by_product_id",
    "get_hero_version_by_id",
    "get_hero_versions",
    "get_last_versions",
    "get_last_version_by_product_id",
    "get_last_version_by_product_name",
    "get_representation_by_id",
    "get_representation_by_name",
    "get_representations",
    "get_representations_parents",
    "get_representation_parents",
    "get_repre_ids_by_context_filters",

    "get_workfiles_info",
    "get_workfile_info",
    "get_workfile_info_by_id",

    "get_thumbnail_by_id",
    "get_thumbnail",
    "get_folder_thumbnail",
    "get_version_thumbnail",
    "get_workfile_thumbnail",
    "create_thumbnail",
    "update_thumbnail",

    "get_full_link_type_name",
    "get_link_types",
    "get_link_type",
    "create_link_type",
    "delete_link_type",
    "make_sure_link_type_exists",

    "create_link",
    "delete_link",
    "get_entities_links",
    "get_folder_links",
    "get_folders_links",
    "get_task_links",
    "get_tasks_links",
    "get_product_links",
    "get_products_links",
    "get_version_links",
    "get_versions_links",
    "get_representations_links",
    "get_representation_links",

    "send_batch_operations",
)
